/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.examples.rest.service;

import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.camel.Exchange;
import org.wildfly.camel.examples.rest.data.CustomerRepository;
import org.wildfly.camel.examples.rest.model.Customer;

@ApplicationScoped
@Named
public class CustomerService {
    @Inject
    CustomerRepository customerRepository;

    public void findAll(Exchange exchange) {
        List customers = this.customerRepository.findAll();
        exchange.getOut().setBody((Object)customers);
    }

    public void findById(Exchange exchange) {
        Long id = (Long)exchange.getIn().getHeader("id", Long.class);
        Customer customer = this.customerRepository.findById(id);
        if (customer != null) {
            exchange.getOut().setBody((Object)customer);
        } else {
            exchange.getOut().setHeader("CamelHttpResponseCode", (Object)404);
        }
    }

    public void create(Exchange exchange) {
        Customer customer = this.customerRepository.save((Customer)exchange.getIn().getBody(Customer.class));
        exchange.getOut().setHeader("CamelHttpResponseCode", (Object)201);
        String URL = (String)exchange.getIn().getHeader("CamelHttpUrl", String.class);
        exchange.getOut().setHeader("Location", (Object)(URL + "/" + customer.getId()));
        exchange.getOut().setBody((Object)customer);
    }

    public void update(Exchange exchange) {
        Long id = (Long)exchange.getIn().getHeader("id", Long.class);
        Customer customer = this.customerRepository.findById(id);
        if (customer != null) {
            Customer updatedCustomer = this.customerRepository.save((Customer)exchange.getIn().getBody(Customer.class));
            String URL = (String)exchange.getIn().getHeader("CamelHttpUrl", String.class);
            exchange.getOut().setHeader("Location", (Object)(URL + "/" + updatedCustomer.getId()));
            exchange.getOut().setHeader("CamelHttpResponseCode", (Object)204);
            exchange.getOut().setBody((Object)updatedCustomer);
        } else {
            exchange.getOut().setHeader("CamelHttpResponseCode", (Object)404);
        }
    }

    public void delete(Exchange exchange) {
        Long id = (Long)exchange.getIn().getHeader("id", Long.class);
        Customer customer = this.customerRepository.findById(id);
        if (customer != null) {
            this.customerRepository.delete(customer);
            exchange.getOut().setHeader("CamelHttpResponseCode", (Object)204);
        } else {
            exchange.getOut().setHeader("CamelHttpResponseCode", (Object)404);
        }
    }
}

