/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.examples.test.common;

import java.io.IOException;
import java.nio.file.Path;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSession;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;

public class SecurityUtils {
    public static SSLConnectionSocketFactory createSocketFactory(Path truststoreFile, Path keystoreFile, String password) throws KeyManagementException, NoSuchAlgorithmException, KeyStoreException, CertificateException, IOException, UnrecoverableKeyException {
        char[] pwd = password.toCharArray();
        SSLContextBuilder sslcontextBuilder = SSLContexts.custom().loadTrustMaterial(truststoreFile.toFile(), pwd, (TrustStrategy)TrustSelfSignedStrategy.INSTANCE);
        if (keystoreFile != null) {
            sslcontextBuilder.loadKeyMaterial(keystoreFile.toFile(), pwd, pwd);
        }
        sslcontextBuilder.setProtocol("TLSv1.2");
        return new SSLConnectionSocketFactory(sslcontextBuilder.build(), new HostnameVerifier(){

            @Override
            public boolean verify(String s, SSLSession sslSession) {
                return true;
            }
        });
    }
}

