/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.examples.test.common;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import java.util.stream.Collectors;

public final class UserManager {
    private static final char[] HEX_CHARS = "0123456789abcdef".toCharArray();
    private static final String JBOSS_HOME = System.getProperty("jboss.home.dir");
    private static final Path CONFIG_DIR = Paths.get(JBOSS_HOME, "standalone", "configuration");
    private static final Path APPLICATION_ROLES = CONFIG_DIR.resolve("application-roles.properties");
    private static final Path APPLICATION_USERS = CONFIG_DIR.resolve("application-users.properties");
    private static final Path MANAGEMENT_ROLES = CONFIG_DIR.resolve("mgmt-roles.properties");
    private static final Path MANAGEMENT_USERS = CONFIG_DIR.resolve("mgmt-users.properties");

    private UserManager() {
    }

    public static void addApplicationUser(String userName, String password) {
        UserManager.addUser(userName, "ApplicationRealm", password, APPLICATION_USERS.toFile());
    }

    public static void addManagementUser(String userName, String password) {
        UserManager.addUser(userName, "ManagementRealm", password, MANAGEMENT_USERS.toFile());
    }

    private static void addUser(String userName, String realm, String password, File propertiesFile) {
        Properties properties = UserManager.readPropertiesFile(propertiesFile);
        properties.put(userName, UserManager.encryptPassword(userName, password, realm));
        UserManager.writePropertiesFile(properties, propertiesFile);
    }

    public static void addRoleToApplicationUser(String userName, String role) {
        UserManager.addRoleToUser(userName, role, APPLICATION_ROLES.toFile());
    }

    public static void addRoleToManagementUser(String userName, String role) {
        UserManager.addRoleToUser(userName, role, MANAGEMENT_ROLES.toFile());
    }

    private static void addRoleToUser(String userName, String role, File propertiesFile) {
        Properties properties = UserManager.readPropertiesFile(propertiesFile);
        properties.put(userName, role);
        UserManager.writePropertiesFile(properties, propertiesFile);
    }

    public static void removeApplicationUser(String userName) {
        UserManager.removeUser(userName, APPLICATION_USERS.toFile());
    }

    public static void removeManagementUser(String userName) {
        UserManager.removeUser(userName, MANAGEMENT_USERS.toFile());
    }

    private static void removeUser(String userName, File propertiesFile) {
        Properties properties = UserManager.readPropertiesFile(propertiesFile);
        properties.remove(userName);
        UserManager.writePropertiesFile(properties, propertiesFile);
    }

    public static void revokeRoleFromApplicationUser(String userName, String role) {
        UserManager.revokeRoleFromUser(userName, role, APPLICATION_ROLES.toFile());
    }

    public static void revokeRoleFromManagementUser(String userName, String role) {
        UserManager.revokeRoleFromUser(userName, role, APPLICATION_ROLES.toFile());
    }

    private static void revokeRoleFromUser(String userName, String role, File propertiesFile) {
        Properties properties = UserManager.readPropertiesFile(propertiesFile);
        String roles = properties.getProperty(userName);
        if (roles != null && !roles.isEmpty()) {
            ArrayList<String> roleList = new ArrayList<String>(Arrays.asList(roles.split(",")));
            roleList.remove(role);
            if (roleList.isEmpty()) {
                properties.remove(userName);
            } else {
                String updatedRoles = roleList.stream().collect(Collectors.joining(","));
                properties.put(userName, updatedRoles);
            }
            properties.put(userName, role);
            UserManager.writePropertiesFile(properties, propertiesFile);
        }
    }

    private static Properties readPropertiesFile(File file) {
        Properties properties = new Properties();
        try (FileReader fr = new FileReader(file);){
            properties.load(fr);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return properties;
    }

    private static void writePropertiesFile(Properties properties, File file) {
        try (FileWriter fw = new FileWriter(file);){
            properties.store(fw, null);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private static String encryptPassword(String userName, String password, String realm) {
        try {
            String stringToEncrypt = String.format("%s:%s:%s", userName, realm, password);
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] hashedPassword = md.digest(stringToEncrypt.getBytes(StandardCharsets.UTF_8));
            char[] converted = new char[hashedPassword.length * 2];
            for (int i = 0; i < hashedPassword.length; ++i) {
                byte b = hashedPassword[i];
                converted[i * 2] = HEX_CHARS[b >> 4 & 0xF];
                converted[i * 2 + 1] = HEX_CHARS[b & 0xF];
            }
            return String.valueOf(converted);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }
}

