/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.examples.test.cdi;

import java.io.File;
import java.net.InetAddress;
import java.net.MalformedURLException;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.camel.test.common.http.HttpRequest;

@RunAsClient
@RunWith(value=Arquillian.class)
public class CDIExampleTest {
    @Deployment
    public static WebArchive createDeployment() {
        return (WebArchive)ShrinkWrap.createFromZipFile(WebArchive.class, (File)new File("target/examples/example-camel-cdi.war"));
    }

    @Test
    public void testCDIRouteWithoutParameter() throws Exception {
        String hostAddress = InetAddress.getLocalHost().getHostAddress();
        HttpRequest.HttpResponse res = HttpRequest.get((String)this.getEndpointAddress("/example-camel-cdi")).getResponse();
        Assert.assertEquals((Object)("Hello world from " + hostAddress), (Object)res.getBody());
    }

    @Test
    public void testCDIRouteWithParameter() throws Exception {
        String hostAddress = InetAddress.getLocalHost().getHostAddress();
        HttpRequest.HttpResponse res = HttpRequest.get((String)this.getEndpointAddress("/example-camel-cdi?name=Kermit")).getResponse();
        Assert.assertEquals((Object)("Hello Kermit from " + hostAddress), (Object)res.getBody());
    }

    private String getEndpointAddress(String contextPath) throws MalformedURLException {
        return "http://localhost:8080" + contextPath;
    }
}

