/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.examples.test.common;

import java.io.Closeable;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import org.jboss.as.arquillian.api.ServerSetupTask;
import org.jboss.as.arquillian.container.ManagementClient;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;
import org.junit.Assert;
import org.xnio.IoUtils;

public class ServerReload {
    private static final Logger log = Logger.getLogger(ServerReload.class);
    public static final int TIMEOUT = 100000;

    public static void executeReloadAndWaitForCompletion(ModelControllerClient client) {
        ServerReload.executeReloadAndWaitForCompletion(client, 100000);
    }

    public static void executeReloadAndWaitForCompletion(ModelControllerClient client, boolean adminOnly) {
        ServerReload.executeReloadAndWaitForCompletion(client, 100000, adminOnly, null, -1);
    }

    public static void executeReloadAndWaitForCompletion(ModelControllerClient client, int timeout) {
        ServerReload.executeReloadAndWaitForCompletion(client, timeout, false, null, -1);
    }

    public static void executeReloadAndWaitForCompletion(ModelControllerClient client, int timeout, boolean adminOnly, String serverAddress, int serverPort) {
        ServerReload.executeReload(client, adminOnly);
        ServerReload.waitForLiveServerToReload(timeout, serverAddress != null ? serverAddress : "localhost", serverPort != -1 ? serverPort : 9990);
    }

    private static void executeReload(ModelControllerClient client, boolean adminOnly) {
        block3: {
            ModelNode operation = new ModelNode();
            operation.get("address").setEmptyList();
            operation.get("operation").set("reload");
            operation.get("admin-only").set(adminOnly);
            try {
                ModelNode result = client.execute(operation);
                if (!"success".equals(result.get("outcome").asString())) {
                    Assert.fail((String)("Reload operation didn't finished successfully: " + result.asString()));
                }
            }
            catch (IOException e) {
                Throwable cause = e.getCause();
                if (cause instanceof ExecutionException || cause instanceof CancellationException) break block3;
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void waitForLiveServerToReload(int timeout, String serverAddress, int serverPort) {
        long start = System.currentTimeMillis();
        ModelNode operation = new ModelNode();
        operation.get("address").setEmptyList();
        operation.get("operation").set("read-attribute");
        operation.get("name").set("server-state");
        while (System.currentTimeMillis() - start < (long)timeout) {
            try {
                ModelControllerClient liveClient = ModelControllerClient.Factory.create((String)serverAddress, (int)serverPort);
                try {
                    ModelNode result = liveClient.execute(operation);
                    if ("running".equals(result.get("result").asString())) {
                        return;
                    }
                }
                catch (IOException iOException) {
                }
                finally {
                    IoUtils.safeClose((Closeable)liveClient);
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
            catch (UnknownHostException e) {
                throw new RuntimeException(e);
            }
        }
        Assert.fail((String)"Live Server did not reload in the imparted time.");
    }

    public static String getContainerRunningState(ManagementClient managementClient) throws IOException {
        return ServerReload.getContainerRunningState(managementClient.getControllerClient());
    }

    public static String getContainerRunningState(ModelControllerClient modelControllerClient) throws IOException {
        ModelNode operation = new ModelNode();
        operation.get("address").setEmptyList();
        operation.get("operation").set("read-attribute");
        operation.get("name").set("server-state");
        ModelNode rsp = modelControllerClient.execute(operation);
        return "success".equals(rsp.get("outcome").asString()) ? rsp.get("result").asString() : "failed";
    }

    public static void reloadIfRequired(ModelControllerClient controllerClient) throws Exception {
        String runningState = ServerReload.getContainerRunningState(controllerClient);
        if ("reload-required".equalsIgnoreCase(runningState)) {
            log.trace((Object)"Server reload is required. The reload will be executed.");
            ServerReload.executeReloadAndWaitForCompletion(controllerClient);
        } else {
            log.debugf("Server reload is not required; server-state is %s", (Object)runningState);
            Assert.assertEquals((String)"Server state 'running' is expected", (Object)"running", (Object)runningState);
        }
    }

    private static class SetupTask
    implements ServerSetupTask {
        private final boolean before;
        private final boolean after;

        private SetupTask(boolean before, boolean after) {
            this.before = before;
            this.after = after;
        }

        public void setup(ManagementClient managementClient, String containerId) throws Exception {
            if (this.before) {
                ServerReload.reloadIfRequired(managementClient.getControllerClient());
            }
        }

        public void tearDown(ManagementClient managementClient, String containerId) throws Exception {
            if (this.after) {
                ServerReload.reloadIfRequired(managementClient.getControllerClient());
            }
        }
    }

    public static class AfterSetupTask
    extends SetupTask {
        public static final AfterSetupTask INSTANCE = new AfterSetupTask();

        public AfterSetupTask() {
            super(false, true);
        }
    }

    public static class BeforeSetupTask
    extends SetupTask {
        public static final BeforeSetupTask INSTANCE = new BeforeSetupTask();

        public BeforeSetupTask() {
            super(true, false);
        }
    }
}

