/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.examples.test.rest;

import java.io.File;
import java.net.MalformedURLException;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.camel.test.common.http.HttpRequest;
import org.wildfly.camel.test.common.utils.TestUtils;

@RunAsClient
@RunWith(value=Arquillian.class)
public class RestSwaggerExampleTest {
    @Deployment
    public static WebArchive createDeployment() {
        return (WebArchive)ShrinkWrap.createFromZipFile(WebArchive.class, (File)new File("target/examples/example-camel-rest-swagger.war"));
    }

    @Test
    public void testCustomerCreate() throws Exception {
        String json = TestUtils.getResourceValue(RestSwaggerExampleTest.class, (String)"/rest/customer.json");
        HttpRequest.HttpResponse response = HttpRequest.post((String)this.getResourceAddress("/customers")).header("Content-Type", "application/json").content(json).getResponse();
        Assert.assertEquals((long)201L, (long)response.getStatusCode());
        Assert.assertTrue((boolean)response.getBody().matches("\\{\"id\":[0-9],\"firstName\":\"John\",\"lastName\":\"Doe\"}"));
    }

    @Test
    public void testCustomerUpdate() throws Exception {
        String json = TestUtils.getResourceValue(RestSwaggerExampleTest.class, (String)"/rest/customer.json");
        HttpRequest.HttpResponse response = HttpRequest.post((String)this.getResourceAddress("/customers")).header("Content-Type", "application/json").content(json).getResponse();
        String id = response.getBody().replaceAll("[^0-9]", "");
        Assert.assertEquals((long)201L, (long)response.getStatusCode());
        String updatedJson = response.getBody().replace("John", "Bob");
        response = HttpRequest.put((String)this.getResourceAddress("/customers/" + id)).content(updatedJson).getResponse();
        Assert.assertEquals((long)204L, (long)response.getStatusCode());
        response = HttpRequest.get((String)this.getResourceAddress("/customers/" + id)).getResponse();
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        Assert.assertEquals((Object)updatedJson, (Object)response.getBody());
    }

    @Test
    public void testCustomerDelete() throws Exception {
        String json = TestUtils.getResourceValue(RestSwaggerExampleTest.class, (String)"/rest/customer.json");
        HttpRequest.HttpResponse response = HttpRequest.post((String)this.getResourceAddress("/customers")).header("Content-Type", "application/json").content(json).getResponse();
        Assert.assertEquals((long)201L, (long)response.getStatusCode());
        String id = response.getBody().replaceAll("[^0-9]", "");
        response = HttpRequest.delete((String)this.getResourceAddress("/customers/" + id)).getResponse();
        Assert.assertEquals((long)204L, (long)response.getStatusCode());
    }

    @Test
    public void testCustomerFindById() throws Exception {
        String json = TestUtils.getResourceValue(RestSwaggerExampleTest.class, (String)"/rest/customer.json");
        HttpRequest.HttpResponse response = HttpRequest.post((String)this.getResourceAddress("/customers")).header("Content-Type", "application/json").content(json).getResponse();
        Assert.assertEquals((long)201L, (long)response.getStatusCode());
        String createdJson = response.getBody();
        String id = createdJson.replaceAll("[^0-9]", "");
        response = HttpRequest.get((String)this.getResourceAddress("/customers/" + id)).getResponse();
        Assert.assertEquals((Object)createdJson, (Object)response.getBody());
    }

    @Test
    public void testCustomerFindWithInvalidId() throws Exception {
        HttpRequest.HttpResponse response = HttpRequest.get((String)this.getResourceAddress("/customers/9999")).getResponse();
        Assert.assertEquals((long)404L, (long)response.getStatusCode());
    }

    @Test
    public void testCustomerFindAll() throws Exception {
        String json = TestUtils.getResourceValue(RestSwaggerExampleTest.class, (String)"/rest/customer.json");
        HttpRequest.post((String)this.getResourceAddress("/customers")).header("Content-Type", "application/json").content(json).getResponse();
        HttpRequest.post((String)this.getResourceAddress("/customers")).header("Content-Type", "application/json").content(json).getResponse();
        HttpRequest.HttpResponse response = HttpRequest.get((String)this.getResourceAddress("/customers")).getResponse();
        Assert.assertTrue((response.getBody().split("},").length >= 2 ? 1 : 0) != 0);
    }

    @Test
    public void testPostBadData() throws Exception {
        HttpRequest.HttpResponse response = HttpRequest.post((String)this.getResourceAddress("/customers")).throwExceptionOnFailure(false).content("some bad content which should be rejected").getResponse();
        Assert.assertEquals((long)400L, (long)response.getStatusCode());
    }

    @Test
    public void testSwaggerEndpoint() throws Exception {
        HttpRequest.HttpResponse response = HttpRequest.get((String)this.getResourceAddress("/swagger")).getResponse();
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        Assert.assertTrue((boolean)response.getBody().contains("\"title\" : \"WildFly Camel REST API\""));
    }

    @Test
    public void testSwaggerUI() throws Exception {
        HttpRequest.HttpResponse response = HttpRequest.get((String)"http://localhost:8080/example-camel-rest-swagger").getResponse();
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        Assert.assertTrue((boolean)response.getBody().contains("Swagger UI"));
    }

    private String getResourceAddress(String resourcePath) throws MalformedURLException {
        return "http://localhost:8080/rest/api" + resourcePath;
    }
}

