/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.examples.test.activemq;

import java.io.File;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.as.arquillian.api.ServerSetup;
import org.jboss.as.arquillian.api.ServerSetupTask;
import org.jboss.as.arquillian.container.ManagementClient;
import org.jboss.dmr.ModelNode;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.ResourceAdapterArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.runner.RunWith;
import org.wildfly.camel.examples.test.jms.AbstractJMSExampleTest;
import org.wildfly.camel.test.common.utils.DMRUtils;
import org.wildfly.camel.test.common.utils.WildFlyCli;

@RunAsClient
@RunWith(value=Arquillian.class)
@ServerSetup(value={ActiveMQRarSetupTask.class})
public class ActiveMQExampleTest
extends AbstractJMSExampleTest {
    private static final String ACTIVEMQ_EXAMPLE_WAR = "example-camel-activemq.war";
    private static final String ACTIVEMQ_RAR = "activemq-rar.rar";

    @Deployment(name="activemq-rar.rar", testable=false, order=1)
    public static ResourceAdapterArchive createRarDeployment() {
        return (ResourceAdapterArchive)ShrinkWrap.createFromZipFile(ResourceAdapterArchive.class, (File)new File("target/examples/activemq-rar.rar"));
    }

    @Deployment(name="example-camel-activemq.war", testable=false, order=2)
    public static WebArchive createDeployment() {
        return (WebArchive)ShrinkWrap.createFromZipFile(WebArchive.class, (File)new File("target/examples/example-camel-activemq.war"));
    }

    @Override
    protected String getContextName() {
        return "camel-activemq-context";
    }

    static class ActiveMQRarSetupTask
    implements ServerSetupTask {
        ActiveMQRarSetupTask() {
        }

        public void setup(ManagementClient managementClient, String s) throws Exception {
            ModelNode batchNode = DMRUtils.batchNode().addStep("subsystem=resource-adapters/resource-adapter=amq-ra.rar", "add(archive=activemq-rar.rar)").addStep("subsystem=resource-adapters/resource-adapter=amq-ra.rar", "write-attribute(name=transaction-support,value=NoTransaction)").addStep("subsystem=resource-adapters/resource-adapter=amq-ra.rar/connection-definitions=QueueConnectionFactory", "add(class-name=org.apache.activemq.ra.ActiveMQManagedConnectionFactory, jndi-name=java:/ActiveMQConnectionFactory)").addStep("subsystem=resource-adapters/resource-adapter=amq-ra.rar/connection-definitions=QueueConnectionFactory/config-properties=ServerUrl", "add(value=vm://localhost?broker.persistent=false&broker.useJmx=false&broker.useShutdownHook=false)").addStep("subsystem=resource-adapters/resource-adapter=amq-ra.rar/admin-objects=OrdersQueue", "add(class-name=org.apache.activemq.command.ActiveMQQueue, jndi-name=java:/OrdersQueue)").addStep("subsystem=resource-adapters/resource-adapter=amq-ra.rar/admin-objects=OrdersQueue/config-properties=PhysicalName", "add(value=OrdersQueue)").build();
            managementClient.getControllerClient().execute(batchNode);
            new WildFlyCli().run("reload", new String[0]).assertSuccess();
        }

        public void tearDown(ManagementClient managementClient, String s) throws Exception {
            ModelNode batchNode = DMRUtils.batchNode().addStep("subsystem=resource-adapters/resource-adapter=amq-ra.rar", "remove").build();
            managementClient.getControllerClient().execute(batchNode);
        }
    }
}

