/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.examples.test.jms;

import org.jboss.as.arquillian.api.ServerSetupTask;
import org.jboss.as.arquillian.container.ManagementClient;
import org.jboss.as.controller.client.ModelControllerClient;
import org.wildfly.camel.examples.test.common.FileConsumerTestSupport;
import org.wildfly.camel.test.common.utils.JMSUtils;

public abstract class AbstractJMSExampleTest
extends FileConsumerTestSupport {
    private static String ORDERS_QUEUE = "OrdersQueue";
    private static String ORDERS_QUEUE_JNDI = "java:/jms/queue/OrdersQueue";

    @Override
    protected String getExpectedLogMessage() {
        return String.format(".*%s.*Sending order to (the UK|another country|the US)$", this.getContextName());
    }

    static class JmsQueueSetup
    implements ServerSetupTask {
        JmsQueueSetup() {
        }

        public void setup(ManagementClient managementClient, String containerId) throws Exception {
            JMSUtils.createJmsQueue((String)ORDERS_QUEUE, (String)ORDERS_QUEUE_JNDI, (ModelControllerClient)managementClient.getControllerClient());
        }

        public void tearDown(ManagementClient managementClient, String containerId) throws Exception {
            JMSUtils.removeJmsQueue((String)ORDERS_QUEUE, (ModelControllerClient)managementClient.getControllerClient());
        }
    }
}

