/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.jms;

import org.jboss.as.arquillian.api.ServerSetupTask;
import org.jboss.as.arquillian.container.ManagementClient;
import org.jboss.as.controller.client.ModelControllerClient;
import org.junit.Assert;
import org.junit.Test;
import org.wildfly.camel.test.common.FileConsumingTestSupport;
import org.wildfly.camel.test.common.ServerLogReader;
import org.wildfly.camel.test.common.utils.JMSUtils;

public abstract class AbstractJMSExampleTest
extends FileConsumingTestSupport {
    private static String ORDERS_QUEUE = "OrdersQueue";
    private static String ORDERS_QUEUE_JNDI = "java:/jms/queue/OrdersQueue";

    @Test
    public void testFileToJmsRoute() throws Exception {
        boolean logMessagePresent = ServerLogReader.awaitLogMessage(".*Sending order to (the UK|another country|the US)$", 10000L);
        Assert.assertTrue((boolean)logMessagePresent);
    }

    static class JmsQueueSetup
    implements ServerSetupTask {
        JmsQueueSetup() {
        }

        public void setup(ManagementClient managementClient, String containerId) throws Exception {
            JMSUtils.createJmsQueue((String)ORDERS_QUEUE, (String)ORDERS_QUEUE_JNDI, (ModelControllerClient)managementClient.getControllerClient());
        }

        public void tearDown(ManagementClient managementClient, String containerId) throws Exception {
            JMSUtils.removeJmsQueue((String)ORDERS_QUEUE, (ModelControllerClient)managementClient.getControllerClient());
        }
    }
}

