/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.examples.jms.transacted;

import javax.enterprise.context.ApplicationScoped;
import org.apache.camel.Predicate;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.TransactedDefinition;
import org.apache.camel.model.dataformat.JaxbDataFormat;
import org.wildfly.camel.examples.jms.transacted.model.Order;

@ApplicationScoped
public class JmsRouteBuilder
extends RouteBuilder {
    public void configure() throws Exception {
        JaxbDataFormat jaxbDataFormat = new JaxbDataFormat();
        jaxbDataFormat.setContextPath(Order.class.getPackage().getName());
        this.onException(IllegalStateException.class).maximumRedeliveries(1).handled(true).markRollbackOnly();
        ((ProcessorDefinition)((RouteDefinition)this.from("timer:order?period=15s&delay=0").bean((Object)"orderGenerator", "generateOrder")).setHeader("CamelFileName").method("orderGenerator", "generateFileName")).to("file://{{jboss.server.data.dir}}/orders");
        ((TransactedDefinition)this.from("file:{{jboss.server.data.dir}}/orders").transacted().convertBodyTo(String.class)).to("jms:queue:OrdersQueue");
        ((ChoiceDefinition)((ChoiceDefinition)((RouteDefinition)((RouteDefinition)this.from("jms:queue:OrdersQueue").unmarshal((DataFormatDefinition)jaxbDataFormat)).to("jpa:Order")).choice().when((Predicate)this.simple("${body.quantity} > 10")).log("Order quantity is greater than 10 - rolling back transaction!")).throwException((Exception)new IllegalStateException("Invalid quantity"))).otherwise().log("Order processed successfully");
    }
}

