/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.examples.jms;

import javax.annotation.Resource;
import javax.enterprise.context.ApplicationScoped;
import javax.jms.ConnectionFactory;
import org.apache.camel.Predicate;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.cdi.ContextName;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;

@ApplicationScoped
@ContextName(value="camel-jms-context")
public class JmsRouteBuilder
extends RouteBuilder {
    @Resource(mappedName="java:jboss/DefaultJMSConnectionFactory")
    private ConnectionFactory connectionFactory;

    public void configure() throws Exception {
        ((ProcessorDefinition)((RouteDefinition)this.from("timer:order?period=5s&delay=0").bean((Object)"orderGenerator", "generateOrder")).setHeader("CamelFileName").method("orderGenerator", "generateFileName")).to("file://{{jboss.server.data.dir}}/orders");
        ((RouteDefinition)((RouteDefinition)this.from("file://{{jboss.server.data.dir}}/orders").convertBodyTo(String.class)).removeHeaders("*")).to("jms:queue:OrdersQueue");
        ((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)this.from("jms:queue:OrdersQueue").choice().when((Predicate)this.xpath("/order/customer/country = 'UK'")).log("Sending order to the UK")).to("file:{{jboss.server.data.dir}}/orders/processed/UK")).when((Predicate)this.xpath("/order/customer/country = 'US'")).log("Sending order to the US")).to("file:{{jboss.server.data.dir}}/orders/processed/US")).otherwise().log("Sending order to another country")).to("file://{{jboss.server.data.dir}}/orders/processed/other");
    }
}

