/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.examples.jms;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.wildfly.camel.examples.jms.OrderGenerator;

@WebServlet(name="HttpServiceServlet", urlPatterns={"/orders/*"}, loadOnStartup=1)
public class JmsServlet
extends HttpServlet {
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        HashMap<String, Integer> orderCounts = new HashMap<String, Integer>();
        for (String country : OrderGenerator.COUNTRIES) {
            int orderCount = this.countOrdersForCountry(country);
            if (orderCount <= 0) continue;
            orderCounts.put(country, orderCount);
        }
        request.setAttribute("orders", orderCounts);
        request.getRequestDispatcher("orders.jsp").forward((ServletRequest)request, (ServletResponse)response);
    }

    private int countOrdersForCountry(String country) throws IOException {
        Path countryPath = new File(System.getProperty("jboss.server.data.dir")).toPath().resolve("orders/processed/" + country);
        File file = countryPath.toFile();
        if (file.isDirectory()) {
            return file.list().length;
        }
        return 0;
    }
}

