/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.examples.rest;

import com.fasterxml.jackson.core.JsonParseException;
import javax.enterprise.context.ApplicationScoped;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.cdi.ContextName;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.rest.RestBindingMode;
import org.apache.camel.model.rest.RestParamType;
import org.wildfly.camel.examples.rest.model.Customer;
import org.wildfly.camel.examples.rest.service.CustomerService;

@ApplicationScoped
@ContextName(value="camel-rest-context")
public class RestRouteBuilder
extends RouteBuilder {
    public void configure() throws Exception {
        ((OnExceptionDefinition)((OnExceptionDefinition)this.onException(JsonParseException.class).handled(true).setHeader("CamelHttpResponseCode", (Expression)this.constant((Object)400))).setHeader("Content-Type", (Expression)this.constant((Object)"text/plain"))).setBody().constant((Object)"Invalid json data");
        this.restConfiguration().bindingMode(RestBindingMode.json).component("undertow").contextPath("rest/api").host("localhost").port(8080).enableCORS(true).apiProperty("api.title", "WildFly Camel REST API").apiProperty("api.version", "1.0").apiContextPath("swagger");
        ((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)this.rest("/customers").description("Customers REST service").get().description("Retrieves all customers").produces("application/json").route().bean(CustomerService.class, "findAll")).endRest().get("/{id}").description("Retrieves a customer for the specified id").param().name("id").description("Customer ID").type(RestParamType.path).dataType("int").endParam().produces("application/json").route().bean(CustomerService.class, "findById")).endRest().post().description("Creates a new customer").consumes("application/json").produces("application/json").type(Customer.class).route().bean(CustomerService.class, "create")).endRest().put("/{id}").description("Updates the customer relating to the specified id").param().name("id").description("Customer ID").type(RestParamType.path).dataType("int").endParam().consumes("application/json").type(Customer.class).route().bean(CustomerService.class, "update")).endRest().delete("/{id}").description("Deletes the customer relating to the specified id").param().name("id").description("Customer ID").type(RestParamType.path).dataType("int").endParam().route().bean(CustomerService.class, "delete")).endRest();
    }
}

