/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.camel.config;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Properties;
import java.util.ServiceLoader;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoader;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.wildfly.extension.camel.config.ConfigContext;
import org.wildfly.extension.camel.config.ConfigException;
import org.wildfly.extension.camel.config.ConfigLogger;
import org.wildfly.extension.camel.config.ConfigPlugin;
import org.wildfly.extension.camel.config.LayerConfig;
import org.wildfly.extension.camel.config.WildFlyCamelConfigPlugin;
import org.wildfly.extension.camel.config.internal.IllegalStateAssertion;

public class ConfigSupport {
    public static ConfigContext createContext(Path jbossHome, Path configuration, Document doc) {
        return new ConfigContext(jbossHome, configuration, doc);
    }

    public static void applyConfigChange(Path jbossHome, List<String> configs, boolean enable) throws Exception {
        Iterator<ConfigPlugin> itsrv;
        IllegalStateAssertion.assertFalse(configs.isEmpty(), "No configurations specified");
        ClassLoader classLoader = ConfigSupport.class.getClassLoader();
        if (classLoader instanceof ModuleClassLoader) {
            ArrayList<ConfigPlugin> plugins = new ArrayList<ConfigPlugin>();
            for (String config : configs) {
                ModuleLoader moduleLoader = Module.getCallerModuleLoader();
                ModuleIdentifier modid = ModuleIdentifier.create((String)("org.wildfly.extension.camel.config.plugin." + config));
                ModuleClassLoader modcl = moduleLoader.loadModule(modid).getClassLoader();
                Iterator<ConfigPlugin> auxit = ServiceLoader.load(ConfigPlugin.class, (ClassLoader)modcl).iterator();
                while (auxit.hasNext()) {
                    plugins.add(auxit.next());
                }
            }
            itsrv = plugins.iterator();
        } else {
            itsrv = ServiceLoader.load(ConfigPlugin.class, classLoader).iterator();
        }
        while (itsrv.hasNext()) {
            ConfigPlugin plugin = itsrv.next();
            if (!configs.contains(plugin.getConfigName())) continue;
            ConfigLogger.info("Processing config for: " + plugin.getConfigName());
            ConfigSupport.applyLayerChanges(jbossHome, plugin, enable);
            ConfigSupport.applyConfigurationChanges(jbossHome, plugin, enable);
        }
    }

    public static void applyLayerChanges(Path jbossHome, ConfigPlugin plugin, boolean enable) throws IOException {
        String layersValue;
        File layersFile = jbossHome.resolve(Paths.get("modules", "layers.conf")).toFile();
        Properties layersProperties = new Properties();
        List<String> layers = new ArrayList<String>();
        if (layersFile.exists()) {
            String[] stringArray = null;
            try (FileInputStream is = new FileInputStream(layersFile);){
                layersProperties.load(is);
            }
            catch (Throwable throwable) {
                stringArray = throwable;
                throw throwable;
            }
            layersValue = layersProperties.getProperty("layers");
            if (layersValue == null) {
                layersValue = "";
            }
            for (String s : layersValue.split(",")) {
                if ((s = s.trim()).length() <= 0) continue;
                layers.add(s);
            }
        }
        layers = ConfigSupport.applyLayerChanges(plugin, layers, enable);
        layersValue = "";
        for (String layer : layers) {
            if (layersValue.length() != 0) {
                layersValue = layersValue + ",";
            }
            layersValue = layersValue + layer;
        }
        layersProperties.put("layers", layersValue);
        ConfigLogger.info("\tWriting 'layers=" + layersValue + "' to: " + layersFile);
        try (FileOutputStream out = new FileOutputStream(layersFile);){
            layersProperties.store(out, null);
        }
    }

    public static List<String> applyLayerChanges(ConfigPlugin plugin, List<String> layers, boolean enable) throws IOException {
        class LayerData
        implements Comparable<LayerData> {
            String name;
            int primaryPriority;
            int secondaryPriority;
            LayerConfig config;

            LayerData() {
            }

            @Override
            public int compareTo(LayerData o) {
                if (o.primaryPriority != this.primaryPriority) {
                    return this.primaryPriority - o.primaryPriority;
                }
                return this.secondaryPriority - o.secondaryPriority;
            }
        }
        LayerData ld;
        ArrayList<LayerData> workingList = new ArrayList<LayerData>();
        ArrayList<LayerConfig> configs = new ArrayList<LayerConfig>(plugin.getLayerConfigs());
        int secondaryCounter = 0;
        for (int i = 0; i < layers.size(); ++i) {
            String name = layers.get(i);
            ld = new LayerData();
            ld.name = name;
            ld.primaryPriority = 0;
            ld.secondaryPriority = i;
            boolean add = true;
            for (LayerConfig config : configs) {
                if (!config.pattern.matcher(name).matches()) continue;
                if (enable) {
                    ld.config = config;
                    if (config.type == LayerConfig.Type.INSTALLING) {
                        ld.name = config.name;
                    }
                    ld.primaryPriority = config.priority;
                    ld.secondaryPriority = secondaryCounter++;
                    break;
                }
                if (config.type != LayerConfig.Type.INSTALLING) break;
                add = false;
                break;
            }
            if (!add) continue;
            workingList.add(ld);
        }
        for (LayerData layerData : workingList) {
            if (layerData.config == null) continue;
            configs.remove(layerData.config);
        }
        for (LayerConfig config : configs) {
            switch (config.type) {
                case OPTIONAL: {
                    break;
                }
                case REQUIRED: {
                    if (!enable) break;
                    throw new ConfigException("Required layer has not yet been configured: " + config.name);
                }
                case INSTALLING: {
                    if (!enable) break;
                    ld = new LayerData();
                    ld.name = config.name;
                    ld.config = config;
                    ld.primaryPriority = config.priority;
                    ld.secondaryPriority = secondaryCounter++;
                    workingList.add(ld);
                }
            }
        }
        Collections.sort(workingList);
        ArrayList<String> result = new ArrayList<String>();
        for (LayerData layerData : workingList) {
            result.add(layerData.name);
        }
        if (result.isEmpty()) {
            result.add(WildFlyCamelConfigPlugin.FUSE_LAYER_CONFIG.name);
        }
        return Collections.unmodifiableList(result);
    }

    private static void applyConfigurationChanges(Path jbossHome, ConfigPlugin plugin, boolean enable) throws Exception {
        String newXML;
        XMLOutputter output;
        ConfigContext context;
        Document doc;
        Path path;
        ArrayList<Path> standalonePaths = new ArrayList<Path>();
        standalonePaths.add(Paths.get("standalone", "configuration", "standalone.xml"));
        standalonePaths.add(Paths.get("standalone", "configuration", "standalone-full.xml"));
        standalonePaths.add(Paths.get("standalone", "configuration", "standalone-full-ha.xml"));
        standalonePaths.add(Paths.get("standalone", "configuration", "standalone-ha.xml"));
        ArrayList<Path> domainPaths = new ArrayList<Path>();
        domainPaths.add(Paths.get("domain", "configuration", "domain.xml"));
        String message = (enable ? "\tEnable " : "\tDisable ") + plugin.getConfigName() + " configuration in: ";
        String lineSeparator = System.getProperty("line.separator");
        SAXBuilder jdom = new SAXBuilder();
        for (Path p : standalonePaths) {
            path = jbossHome.resolve(p);
            if (!path.toFile().exists()) continue;
            ConfigLogger.info(message + path);
            doc = jdom.build(path.toUri().toURL());
            context = new ConfigContext(jbossHome, path, doc);
            plugin.applyStandaloneConfigChange(context, enable);
            output = new XMLOutputter();
            output.setFormat(Format.getRawFormat().setLineSeparator(lineSeparator));
            newXML = output.outputString(doc);
            ConfigSupport.backup(path);
            ConfigSupport.writeFile(path, newXML, "UTF-8");
        }
        for (Path p : domainPaths) {
            path = jbossHome.resolve(p);
            if (!path.toFile().exists()) continue;
            ConfigLogger.info(message + path);
            doc = jdom.build(path.toUri().toURL());
            context = new ConfigContext(jbossHome, path, doc);
            plugin.applyDomainConfigChange(context, enable);
            output = new XMLOutputter();
            output.setFormat(Format.getRawFormat().setLineSeparator(lineSeparator));
            newXML = output.outputString(doc);
            ConfigSupport.backup(path);
            ConfigSupport.writeFile(path, newXML, "UTF-8");
        }
    }

    public static Path getJBossHome() throws UnsupportedEncodingException {
        Path currpath;
        String jbossHome = System.getProperty("jboss.home");
        if (jbossHome == null) {
            jbossHome = System.getProperty("jboss.home.dir");
        }
        if (jbossHome == null) {
            jbossHome = System.getenv("JBOSS_HOME");
        }
        if (jbossHome == null && (currpath = Paths.get(".", new String[0])).resolve("jboss-modules.jar").toFile().exists()) {
            jbossHome = currpath.toAbsolutePath().toString();
        }
        IllegalStateAssertion.assertNotNull(jbossHome, "Cannot obtain JBOSS_HOME: " + jbossHome);
        IllegalStateAssertion.assertTrue(Paths.get(jbossHome, new String[0]).toFile().isDirectory(), "Not a valid directory: " + jbossHome);
        Path standalonePath = Paths.get(jbossHome, "standalone", "configuration");
        if (!standalonePath.toFile().exists()) {
            throw new ConfigException("Path to standalone configutration does not exist: " + standalonePath);
        }
        Path domainPath = Paths.get(jbossHome, "domain", "configuration");
        if (!domainPath.toFile().exists()) {
            throw new ConfigException("Path to domain configutration does not exist: " + domainPath);
        }
        return Paths.get(jbossHome, new String[0]);
    }

    public static Element createElementFromText(String xml) {
        Document doc;
        SAXBuilder jdom = new SAXBuilder();
        try {
            doc = jdom.build((Reader)new StringReader(xml));
        }
        catch (IOException | JDOMException ex) {
            throw new RuntimeException(ex);
        }
        return (Element)doc.getRootElement().clone();
    }

    public static Element loadElementFrom(URL resource) {
        try {
            byte[] data = ConfigSupport.loadBytesFromURL(resource);
            String xml = new String(data, "UTF-8");
            return ConfigSupport.createElementFromText(xml);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] loadBytesFromURL(URL resource) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[10234];
        try (InputStream in = resource.openStream();){
            int count;
            while ((count = in.read(buffer, 0, buffer.length)) >= 0) {
                out.write(buffer, 0, count);
            }
        }
        return out.toByteArray();
    }

    public static Element findElementWithAttributeValue(Element element, String name, Namespace ns, String attrName, String attrValue) {
        Attribute attribute;
        if (element.getName().equals(name) && element.getNamespace().equals((Object)ns) && (attribute = element.getAttribute(attrName)) != null && attrValue.equals(attribute.getValue())) {
            return element;
        }
        for (Element ch : element.getChildren()) {
            Element result = ConfigSupport.findElementWithAttributeValue(ch, name, ns, attrName, attrValue);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static void assertExists(Element extensions, String message) {
        if (extensions == null) {
            throw new ConfigException(message);
        }
    }

    private static void backup(Path path) throws IOException {
        String name = path + ".bak";
        int counter = 2;
        while (Files.exists(Paths.get(name, new String[0]), new LinkOption[0])) {
            name = path + ".bak" + counter;
            ++counter;
        }
        Files.copy(path, Paths.get(name, new String[0]), new CopyOption[0]);
    }

    private static Path writeFile(Path path, String value, String encoding) throws IOException {
        byte[] bytes = value.getBytes(encoding);
        return Files.write(path, bytes, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
    }

    static LinkedHashMap<String, Element> mapByAttributeName(List<Element> elements, String attrName) {
        LinkedHashMap<String, Element> rc = new LinkedHashMap<String, Element>();
        for (Element element : elements) {
            Attribute attribute = element.getAttribute(attrName);
            if (attribute == null) continue;
            rc.put(attribute.getValue(), element);
        }
        return rc;
    }

    public static List<Element> findProfileElements(Document doc, Namespace ns) {
        Element profiles;
        ArrayList<Element> result = new ArrayList<Element>();
        Element profile = doc.getRootElement().getChild("profile", ns);
        if (profile != null) {
            result.add(profile);
        }
        if ((profiles = doc.getRootElement().getChild("profiles", ns)) != null) {
            result.addAll(profiles.getChildren("profile", ns));
        }
        return result;
    }
}

