/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.common;

import java.util.ArrayList;
import java.util.List;
import org.jboss.as.domain.management.security.adduser.AddUser;

public final class UserManagement {
    private UserManagement() {
    }

    public static UserBuilder applicationUser() {
        return new UserBuilder().applicationUser();
    }

    public static UserBuilder managementUser() {
        return new UserBuilder();
    }

    public static final class UserBuilder {
        private List<String> args = new ArrayList<String>();

        private UserBuilder() {
            this.args.add("-s");
        }

        public UserBuilder username(String username) {
            this.addArgs("-u", username);
            return this;
        }

        public UserBuilder password(String password) {
            this.addArgs("-p", password);
            return this;
        }

        public UserBuilder group(String group) {
            this.addArgs("-g", group);
            return this;
        }

        public void create() {
            AddUser.main((String[])this.args.toArray(new String[this.args.size()]));
        }

        private UserBuilder applicationUser() {
            this.addArgs("-a");
            return this;
        }

        private void addArgs(String ... args) {
            for (String arg : args) {
                this.args.add(arg);
            }
        }
    }
}

