/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.common.docker;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class DockerCommand {
    private List<String> options = new ArrayList<String>();
    private List<String> args = new ArrayList<String>();
    private String cmd;

    public DockerCommand(String cmd) {
        this.cmd = cmd;
    }

    public DockerCommand options(String ... opts) {
        for (String p : opts) {
            this.options.add(p);
        }
        return this;
    }

    public DockerCommand args(String ... params) {
        for (String p : params) {
            this.args.add(p);
        }
        return this;
    }

    protected void buildCommand(List<String> carr) {
        carr.add("docker");
        carr.add(this.cmd);
        carr.addAll(this.options);
        this.appendsArgs(carr);
    }

    protected void appendsArgs(List<String> carr) {
        carr.addAll(this.args);
    }

    public final Result exec() {
        Process process;
        ArrayList<String> carr = new ArrayList<String>();
        this.buildCommand(carr);
        StringBuffer cbuf = new StringBuffer();
        for (String item : carr) {
            cbuf.append(item + " ");
        }
        System.out.println("DOCKER> " + cbuf);
        try {
            process = Runtime.getRuntime().exec(carr.toArray(new String[carr.size()]));
            process.waitFor();
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
        Result result = new Result(process);
        return result;
    }

    public static class Result {
        private Process process;
        private BufferedReader output;

        Result(Process process) {
            this.process = process;
        }

        public String outputLine() {
            Iterator<String> it = this.outputLines();
            return it.hasNext() ? it.next() : null;
        }

        private BufferedReader getOutputReader() {
            if (this.output == null) {
                this.output = new BufferedReader(new InputStreamReader(this.process.getInputStream()));
            }
            return this.output;
        }

        public Iterator<String> outputLines() {
            return new Iterator<String>(){
                String nextLine;

                @Override
                public boolean hasNext() {
                    return this.nextLine() != null;
                }

                @Override
                public String next() {
                    String result = this.nextLine();
                    if (result == null) {
                        throw new NoSuchElementException();
                    }
                    this.nextLine = null;
                    return result;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }

                private String nextLine() {
                    if (this.nextLine == null) {
                        try {
                            this.nextLine = Result.this.getOutputReader().readLine();
                        }
                        catch (IOException e) {
                            return null;
                        }
                    }
                    return this.nextLine;
                }
            };
        }

        public int exitValue() {
            return this.process.exitValue();
        }

        public Result printOut(PrintStream out) {
            Iterator<String> itout = this.outputLines();
            while (itout.hasNext()) {
                out.println(itout.next());
            }
            return this;
        }

        public Result printErr(PrintStream out) {
            BufferedReader error = new BufferedReader(new InputStreamReader(this.process.getErrorStream()));
            try {
                String line = error.readLine();
                while (line != null) {
                    out.println(line);
                    line = error.readLine();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return this;
        }
    }
}

