/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.common;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public final class HttpRequest {
    private HttpRequest() {
    }

    public static HttpRequestBuilder get(String url) {
        return new HttpRequestBuilder(url, "GET");
    }

    public static HttpRequestBuilder post(String url) {
        return new HttpRequestBuilder(url, "POST");
    }

    public static HttpRequestBuilder put(String url) {
        return new HttpRequestBuilder(url, "PUT");
    }

    public static HttpRequestBuilder delete(String url) {
        return new HttpRequestBuilder(url, "DELETE");
    }

    public static class HttpResponse {
        private int statusCode;
        private String body;

        public int getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(int statusCode) {
            this.statusCode = statusCode;
        }

        public String getBody() {
            return this.body;
        }

        public void setBody(String body) {
            this.body = body;
        }

        public String toString() {
            return "HttpResponse{status=" + this.statusCode + "}";
        }
    }

    public static final class HttpRequestBuilder {
        private String requestUrl;
        private String method;
        private String content;
        private long timeout = 10L;
        private boolean throwExceptionOnFailure = true;
        private Map<String, String> headers = new HashMap<String, String>();
        private TimeUnit timeUnit = TimeUnit.SECONDS;

        HttpRequestBuilder(String url, String method) {
            this.requestUrl = url;
            this.method = method;
        }

        public HttpRequestBuilder content(String value) {
            this.content = value;
            return this;
        }

        public HttpRequestBuilder header(String name, String value) {
            this.headers.put(name, value);
            return this;
        }

        public HttpRequestBuilder throwExceptionOnFailure(boolean value) {
            this.throwExceptionOnFailure = value;
            return this;
        }

        public HttpRequestBuilder timeout(long value) {
            this.timeout = value;
            return this;
        }

        public HttpRequestBuilder timeout(long value, TimeUnit unit) {
            this.timeout = value;
            this.timeUnit = unit;
            return this;
        }

        public HttpResponse getResponse() throws TimeoutException, IOException {
            Callable<HttpResponse> task = new Callable<HttpResponse>(){

                @Override
                public HttpResponse call() throws Exception {
                    URL url = new URL(HttpRequestBuilder.this.requestUrl);
                    HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                    conn.setDoInput(true);
                    conn.setRequestMethod(HttpRequestBuilder.this.method);
                    Set headerNames = HttpRequestBuilder.this.headers.keySet();
                    for (String headerName : headerNames) {
                        conn.setRequestProperty(headerName, (String)HttpRequestBuilder.this.headers.get(headerName));
                    }
                    if (HttpRequestBuilder.this.method.equals("POST") || HttpRequestBuilder.this.method.equals("PUT")) {
                        conn.setDoOutput(true);
                    }
                    if (HttpRequestBuilder.this.content != null && !HttpRequestBuilder.this.content.isEmpty()) {
                        OutputStream outputStream = conn.getOutputStream();
                        outputStream.write(HttpRequestBuilder.this.content.getBytes("UTF-8"));
                        outputStream.flush();
                        outputStream.close();
                    }
                    return HttpRequestBuilder.this.processResponse(conn);
                }
            };
            return this.executeRequest(task, this.timeout, this.timeUnit);
        }

        /*
         * Exception decompiling
         */
        private HttpResponse executeRequest(Callable<HttpResponse> task, long timeout, TimeUnit unit) throws TimeoutException, IOException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private String read(InputStream in) throws IOException {
            int b;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            while ((b = in.read()) != -1) {
                out.write(b);
            }
            return out.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private HttpResponse processResponse(HttpURLConnection conn) throws IOException {
            InputStream err;
            int responseCode = conn.getResponseCode();
            if (this.throwExceptionOnFailure && responseCode != 200 && (err = conn.getErrorStream()) != null) {
                try {
                    throw new IOException(this.read(err));
                }
                catch (Throwable throwable) {
                    err.close();
                    throw throwable;
                }
            }
            try (InputStream in = conn.getInputStream();){
                HttpResponse result = new HttpResponse();
                result.setStatusCode(responseCode);
                result.setBody(this.read(in));
                HttpResponse httpResponse = result;
                return httpResponse;
            }
        }
    }
}

