/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.common;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.jdom.Document;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public final class XMLUtils {
    private XMLUtils() {
    }

    public static String compactXML(String xmlinput) throws Exception {
        return XMLUtils.compactXML(new ByteArrayInputStream(xmlinput.getBytes()));
    }

    public static String compactXML(InputStream input) throws Exception {
        Document doc = new SAXBuilder().build(input);
        XMLOutputter xo = new XMLOutputter();
        xo.setFormat(Format.getCompactFormat().setOmitDeclaration(true));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        xo.output(doc, (OutputStream)baos);
        return new String(baos.toByteArray()).trim();
    }
}

