/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.common.docker;

import java.nio.file.Path;
import java.util.List;
import org.wildfly.camel.test.common.docker.DockerCommand;

public class RunCommand
extends DockerCommand {
    private String image;
    private String cmd;

    public RunCommand() {
        super("run");
    }

    public RunCommand remove() {
        this.options("--rm");
        return this;
    }

    public RunCommand entrypoint(String entrypoint) {
        this.options("--entrypoint=" + entrypoint);
        return this;
    }

    public RunCommand port(int host, int container) {
        this.options("-p", host + ":" + container);
        return this;
    }

    public RunCommand volume(Path host, Path container) {
        this.options("-v", host.toAbsolutePath() + ":" + container.toAbsolutePath());
        return this;
    }

    public RunCommand image(String image) {
        this.image = image;
        return this;
    }

    public RunCommand cmd(String cmd) {
        this.cmd = cmd;
        return this;
    }

    @Override
    protected void appendsArgs(List<String> carr) {
    }

    @Override
    protected void buildCommand(List<String> carr) {
        super.buildCommand(carr);
        carr.add(this.image);
        if (this.cmd != null) {
            carr.add(this.cmd);
        }
        super.appendsArgs(carr);
    }
}

