/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.policy;

import javax.ejb.EJBAccessException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.security.auth.login.LoginContext;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.camel.test.policy.subA.AnnotatedSLSB;
import org.wildfly.camel.test.policy.subA.SecureRouteBuilder;
import org.wildfly.extension.camel.security.LoginContextBuilder;

@RunWith(value=Arquillian.class)
public class EJBSecurityTestCase {
    @Deployment
    public static JavaArchive createDeployment() {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"ejb-security-test.jar");
        archive.addClasses(new Class[]{AnnotatedSLSB.class, SecureRouteBuilder.class});
        archive.addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
        return archive;
    }

    @Test
    public void testAccessAllowed() throws Exception {
        AnnotatedSLSB bean = this.lookup(new InitialContext(), AnnotatedSLSB.class, AnnotatedSLSB.class);
        Assert.assertEquals((Object)"Hello Kermit", (Object)bean.doAnything("Kermit"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAuthorizedAccess() throws Exception {
        AnnotatedSLSB bean = this.lookup(new InitialContext(), AnnotatedSLSB.class, AnnotatedSLSB.class);
        LoginContextBuilder builder = new LoginContextBuilder(LoginContextBuilder.Type.CLIENT).domain("user-domain");
        LoginContext loginContext = builder.username("user2").encryptedPassword("appl-pa$$wrd2".toCharArray()).build();
        loginContext.login();
        try {
            Assert.assertEquals((Object)"Hello Kermit", (Object)bean.doSelected("Kermit"));
        }
        finally {
            loginContext.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCallerPricipalPropagation() throws Exception {
        AnnotatedSLSB bean = this.lookup(new InitialContext(), AnnotatedSLSB.class, AnnotatedSLSB.class);
        LoginContextBuilder builder = new LoginContextBuilder(LoginContextBuilder.Type.CLIENT).domain("user-domain");
        LoginContext loginContext = builder.username("user2").encryptedPassword("appl-pa$$wrd2".toCharArray()).build();
        loginContext.login();
        try {
            Assert.assertEquals((Object)"Hello Kermit", (Object)bean.secureRouteAccess("Kermit"));
        }
        finally {
            loginContext.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUnauthorizedAccess() throws Exception {
        AnnotatedSLSB bean = this.lookup(new InitialContext(), AnnotatedSLSB.class, AnnotatedSLSB.class);
        try {
            bean.doSelected("Kermit");
            Assert.fail((String)"Call to doSelected() method was expected to fail");
        }
        catch (EJBAccessException ejbae) {
            // empty catch block
        }
        LoginContextBuilder builder = new LoginContextBuilder(LoginContextBuilder.Type.CLIENT);
        LoginContext loginContext = builder.username("user1").password("wrongpass".toCharArray()).build();
        loginContext.login();
        try {
            bean.doSelected("Kermit");
            Assert.fail((String)"Call to doSelected() method was expected to fail");
        }
        catch (EJBAccessException ejbae) {
        }
        finally {
            loginContext.logout();
        }
    }

    @Test
    public void testAccessDenied() throws Exception {
        AnnotatedSLSB bean = this.lookup(new InitialContext(), AnnotatedSLSB.class, AnnotatedSLSB.class);
        try {
            bean.restrictedMethod();
            Assert.fail((String)"Call to restrictedMethod() method was expected to fail");
        }
        catch (EJBAccessException eJBAccessException) {
            // empty catch block
        }
    }

    private <T> T lookup(Context ctx, Class<?> beanClass, Class<T> viewClass) throws NamingException {
        return viewClass.cast(ctx.lookup("java:module/" + beanClass.getSimpleName() + "!" + viewClass.getName()));
    }
}

