/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.braintree;

import com.braintreegateway.Customer;
import com.braintreegateway.CustomerRequest;
import com.braintreegateway.Result;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.braintree.BraintreeComponent;
import org.apache.camel.component.braintree.BraintreeConfiguration;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.util.IntrospectionSupport;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.extension.camel.CamelAware;

@CamelAware
@RunWith(value=Arquillian.class)
public class BraintreeIntegrationTest {
    @Deployment
    public static JavaArchive deployment() {
        return (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"camel-braintree-tests");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBraintreeClientTokenGateway() throws Exception {
        Map<String, Object> braintreeOptions = this.createBraintreeOptions();
        Assume.assumeTrue((braintreeOptions.size() == BraintreeOption.values().length ? 1 : 0) != 0);
        final CountDownLatch latch = new CountDownLatch(1);
        DefaultCamelContext camelctx = new DefaultCamelContext();
        BraintreeConfiguration configuration = new BraintreeConfiguration();
        configuration.setHttpLogLevel(Level.WARNING);
        IntrospectionSupport.setProperties((Object)configuration, braintreeOptions);
        BraintreeComponent component = new BraintreeComponent((CamelContext)camelctx);
        component.setConfiguration(configuration);
        camelctx.addComponent("braintree", (Component)component);
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)((RouteDefinition)this.from("timer://braintree?repeatCount=1").to("braintree:clientToken/generate")).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        latch.countDown();
                    }
                })).to("mock:result");
            }
        });
        camelctx.start();
        try {
            Assert.assertTrue((String)"Countdown reached zero", (boolean)latch.await(5L, TimeUnit.MINUTES));
        }
        finally {
            camelctx.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBraintreeCustomerGateway() throws Exception {
        Map<String, Object> braintreeOptions = this.createBraintreeOptions();
        Assume.assumeTrue((braintreeOptions.size() == BraintreeOption.values().length ? 1 : 0) != 0);
        final CountDownLatch latch = new CountDownLatch(2);
        DefaultCamelContext camelctx = new DefaultCamelContext();
        BraintreeConfiguration configuration = new BraintreeConfiguration();
        IntrospectionSupport.setProperties((Object)configuration, braintreeOptions);
        BraintreeComponent component = new BraintreeComponent((CamelContext)camelctx);
        component.setConfiguration(configuration);
        camelctx.addComponent("braintree", (Component)component);
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:create").to("braintree:customer/create?inBody=request")).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        latch.countDown();
                    }
                });
                ((RouteDefinition)this.from("direct:delete").to("braintree:customer/delete?inBody=id")).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        latch.countDown();
                    }
                });
            }
        });
        camelctx.start();
        Result createResult = (Result)camelctx.createProducerTemplate().requestBody("direct:create", (Object)new CustomerRequest().firstName("user").lastName(UUID.randomUUID().toString()).company("Apache").email("user@braintree.camel").website("http://user.braintree.camel"), Result.class);
        Assert.assertNotNull((Object)createResult);
        Assert.assertTrue((boolean)createResult.isSuccess());
        Assert.assertNotNull((Object)createResult.getTarget());
        Assert.assertNotNull((Object)((Customer)createResult.getTarget()).getId());
        Result deleteResult = (Result)camelctx.createProducerTemplate().requestBody("direct:delete", (Object)((Customer)createResult.getTarget()).getId(), Result.class);
        Assert.assertNotNull((Object)deleteResult);
        Assert.assertTrue((boolean)deleteResult.isSuccess());
        Assert.assertNull((Object)deleteResult.getTarget());
        try {
            Assert.assertTrue((String)"Countdown reached zero", (boolean)latch.await(5L, TimeUnit.MINUTES));
        }
        finally {
            camelctx.stop();
        }
    }

    protected Map<String, Object> createBraintreeOptions() throws Exception {
        HashMap<String, Object> options = new HashMap<String, Object>();
        for (BraintreeOption option : BraintreeOption.values()) {
            String envVar = System.getenv(option.name());
            if (envVar == null || envVar.length() == 0) {
                options.clear();
                continue;
            }
            options.put(option.configPropertyName, envVar);
        }
        return options;
    }

    private static enum BraintreeOption {
        CAMEL_BRAINTREE_ENVIRONMENT("environment"),
        CAMEL_BRAINTREE_MERCHANT_ID("merchantId"),
        CAMEL_BRAINTREE_PUBLIC_KEY("publicKey"),
        CAMEL_BRAINTREE_PRIVATE_KEY("privateKey");

        private String configPropertyName;

        private BraintreeOption(String configPropertyName) {
            this.configPropertyName = configPropertyName;
        }
    }
}

