/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.ldap;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Hashtable;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.SimpleRegistry;
import org.apache.camel.spi.Registry;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.codec.standalone.StandaloneLdapApiService;
import org.apache.directory.api.ldap.model.message.Control;
import org.apache.directory.api.ldap.util.JndiUtils;
import org.apache.directory.server.annotations.CreateLdapServer;
import org.apache.directory.server.annotations.CreateTransport;
import org.apache.directory.server.core.annotations.ApplyLdifFiles;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.as.arquillian.api.ServerSetup;
import org.jboss.as.arquillian.api.ServerSetupTask;
import org.jboss.as.arquillian.container.ManagementClient;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.resolver.api.maven.Maven;
import org.jboss.shrinkwrap.resolver.api.maven.MavenFormatStage;
import org.jboss.shrinkwrap.resolver.api.maven.MavenStrategyStage;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.camel.test.ldap.DirectoryServiceBuilder;
import org.wildfly.extension.camel.CamelAware;

@CamelAware
@RunWith(value=Arquillian.class)
@ServerSetup(value={LDAPServerSetupTask.class})
public class LDAPIntegrationTest {
    int ldapPort;

    @Deployment
    public static WebArchive createDeployment() throws Exception {
        File[] libs = ((MavenFormatStage)((MavenStrategyStage)Maven.configureResolverViaPlugin().resolve(new String[]{"org.apache.directory.api:api-ldap-codec-core", "org.apache.directory.api:api-ldap-extras-util", "org.apache.directory.api:api-ldap-codec-standalone"})).withTransitivity()).asFile();
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"camel-ldap-tests.war");
        archive.addAsLibraries(libs);
        return archive;
    }

    @Before
    public void before() throws IOException {
        File ldapPortFile = new File(System.getProperty("jboss.server.data.dir"), "ldap-port");
        try (BufferedReader fw = new BufferedReader(new FileReader(ldapPortFile));){
            this.ldapPort = Integer.parseInt(fw.readLine());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLdapRouteStandard() throws Exception {
        SimpleRegistry reg = new SimpleRegistry();
        reg.put((Object)("localhost:" + this.ldapPort), (Object)this.getWiredContext(this.ldapPort));
        DefaultCamelContext camelctx = new DefaultCamelContext((Registry)reg);
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to("ldap:localhost:" + LDAPIntegrationTest.this.ldapPort + "?base=ou=system");
            }
        });
        camelctx.start();
        try {
            Endpoint endpoint = camelctx.getEndpoint("direct:start");
            Exchange exchange = endpoint.createExchange();
            exchange.getIn().setBody((Object)"(!(ou=test1))");
            Exchange out = camelctx.createProducerTemplate().send(endpoint, exchange);
            Collection<SearchResult> searchResults = this.defaultLdapModuleOutAssertions(out);
            Assert.assertFalse((boolean)this.contains("uid=test1,ou=test,ou=system", searchResults));
            Assert.assertTrue((boolean)this.contains("uid=test2,ou=test,ou=system", searchResults));
            Assert.assertTrue((boolean)this.contains("uid=testNoOU,ou=test,ou=system", searchResults));
            Assert.assertTrue((boolean)this.contains("uid=tcruise,ou=actors,ou=system", searchResults));
        }
        finally {
            camelctx.stop();
        }
    }

    private Collection<SearchResult> defaultLdapModuleOutAssertions(Exchange out) {
        Assert.assertNotNull((Object)out);
        Assert.assertNotNull((Object)out.getOut());
        Collection data = (Collection)out.getOut().getBody(Collection.class);
        Assert.assertNotNull((String)("out body could not be converted to a Collection - was: " + out.getOut().getBody()), (Object)data);
        return data;
    }

    private boolean contains(String dn, Collection<SearchResult> results) {
        for (SearchResult result : results) {
            if (!result.getNameInNamespace().equals(dn)) continue;
            return true;
        }
        return false;
    }

    private LdapContext getWiredContext(int port) throws Exception {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", "ldap://" + InetAddress.getLocalHost().getHostName() + ":" + port);
        env.put("java.naming.security.principal", "uid=admin,ou=system");
        env.put("java.naming.security.credentials", "secret");
        env.put("java.naming.security.authentication", "simple");
        StandaloneLdapApiService ldapApiService = new StandaloneLdapApiService();
        return new InitialLdapContext(env, JndiUtils.toJndiControls((LdapApiService)ldapApiService, (Control[])new Control[0]));
    }

    @CreateLdapServer(transports={@CreateTransport(protocol="LDAP")})
    @ApplyLdifFiles(value={"ldap/LdapRouteTest.ldif"})
    static class LDAPServerSetupTask
    implements ServerSetupTask {
        private DirectoryServiceBuilder.SetupResult setupResult;

        LDAPServerSetupTask() {
        }

        public void setup(ManagementClient managementClient, String containerId) throws Exception {
            this.setupResult = DirectoryServiceBuilder.setupDirectoryService(LDAPServerSetupTask.class);
            int port = this.setupResult.getLdapServer().getPort();
            Path filePath = Paths.get(System.getProperty("jboss.home"), "standalone", "data", "ldap-port");
            try (PrintWriter fw = new PrintWriter(new FileWriter(filePath.toFile()));){
                fw.println("" + port);
            }
        }

        public void tearDown(ManagementClient managementClient, String containerId) throws Exception {
            if (this.setupResult != null) {
                this.setupResult.getLdapServer().stop();
                DirectoryServiceBuilder.shutdownDirectoryService(this.setupResult.getDirectoryService());
            }
        }
    }
}

