/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.weather;

import java.io.File;
import org.apache.camel.Endpoint;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.impl.DefaultCamelContext;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.resolver.api.maven.Maven;
import org.jboss.shrinkwrap.resolver.api.maven.MavenFormatStage;
import org.jboss.shrinkwrap.resolver.api.maven.MavenStrategyStage;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.extension.camel.CamelAware;
import software.betamax.junit.Betamax;
import software.betamax.junit.RecorderRule;

@CamelAware
@RunWith(value=Arquillian.class)
public class WeatherIntegrationTest {
    @Rule
    public RecorderRule recorder = new RecorderRule();

    @Deployment
    public static WebArchive createDeployment() throws Exception {
        File[] libraryDependencies = ((MavenFormatStage)((MavenStrategyStage)Maven.configureResolverViaPlugin().resolve("software.betamax:betamax-junit")).withTransitivity()).asFile();
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"camel-weather-tests.war");
        archive.addAsLibraries(libraryDependencies);
        archive.addAsResource("betamax.properties", "betamax.properties");
        return archive;
    }

    @Test
    public void testComponentLoads() throws Exception {
        DefaultCamelContext camelctx = new DefaultCamelContext();
        Endpoint endpoint = camelctx.getEndpoint("weather:foo?location=Madrid,Spain&period=7 days");
        Assert.assertNotNull((Object)endpoint);
        Assert.assertEquals((Object)endpoint.getClass().getName(), (Object)"org.apache.camel.component.weather.WeatherEndpoint");
        camelctx.stop();
    }

    @Test
    @Betamax(tape="madrid-weather-report")
    public void testGetWeather() throws Exception {
        DefaultCamelContext camelctx = new DefaultCamelContext();
        ProducerTemplate template = camelctx.createProducerTemplate();
        String response = (String)template.requestBody("weather:foo?location=Madrid,Spain&period=7 days&proxyHost=localhost&proxyPort=1337", null, String.class);
        Assert.assertNotNull((Object)response);
        Assert.assertTrue((String)"Contains ", (boolean)response.contains(",\"name\":\"Madrid\","));
        camelctx.stop();
    }
}

