/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.smoke;

import org.apache.camel.CamelContext;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.ServiceStatus;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.as.arquillian.api.ServerSetup;
import org.jboss.as.arquillian.api.ServerSetupTask;
import org.jboss.as.arquillian.container.ManagementClient;
import org.jboss.dmr.ModelNode;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.camel.test.common.DMRUtils;
import org.wildfly.extension.camel.CamelAware;
import org.wildfly.extension.camel.CamelContextRegistry;

@CamelAware
@RunWith(value=Arquillian.class)
@ServerSetup(value={SystemContextSetupTask.class})
public class SystemContextTest {
    @ArquillianResource
    CamelContextRegistry contextRegistry;

    @Deployment
    public static JavaArchive createdeployment() {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"camel-system-tests");
        return archive;
    }

    @Test
    public void testSystemTransformFromModule() throws Exception {
        CamelContext camelctx = this.contextRegistry.getCamelContext("system-context-1");
        Assert.assertNotNull((String)"Camel context System-context-1 was null", (Object)camelctx);
        Assert.assertEquals((Object)ServiceStatus.Started, (Object)camelctx.getStatus());
        ProducerTemplate producer = camelctx.createProducerTemplate();
        String result = (String)producer.requestBody("direct:start", (Object)"Kermit", String.class);
        Assert.assertEquals((Object)"Hello Kermit", (Object)result);
    }

    static class SystemContextSetupTask
    implements ServerSetupTask {
        SystemContextSetupTask() {
        }

        public void setup(ManagementClient managementClient, String containerId) throws Exception {
            String contextXml = "\t\t     <route>\n\t\t       <from uri=\"direct:start\"/>\n\t\t       <transform>\n\t\t         <simple>Hello #{body}</simple>\n\t\t       </transform>\n\t\t     </route>\n";
            ModelNode contextOpAdd = DMRUtils.createOpNode((String)"subsystem=camel/context=system-context-1/", (String)"add");
            contextOpAdd.get("value").set(contextXml);
            managementClient.getControllerClient().execute(DMRUtils.createCompositeNode((ModelNode[])new ModelNode[]{contextOpAdd}));
        }

        public void tearDown(ManagementClient managementClient, String containerId) throws Exception {
            ModelNode contextOpAdd = DMRUtils.createOpNode((String)"subsystem=camel/context=system-context-1/", (String)"remove");
            managementClient.getControllerClient().execute(DMRUtils.createCompositeNode((ModelNode[])new ModelNode[]{contextOpAdd}));
        }
    }
}

