/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.core;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.model.language.SimpleExpression;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.camel.test.core.subA.RecipientListBean;

@RunWith(value=Arquillian.class)
public class RecipientListTest {
    @Deployment
    public static JavaArchive deployment() {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"recipient-tests");
        archive.addClasses(new Class[]{RecipientListBean.class});
        return archive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSimpleRecipientList() throws Exception {
        final CountDownLatch latch = new CountDownLatch(2);
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").recipientList((Expression)new SimpleExpression("direct:one, direct:two"), ",");
                this.from("direct:one").process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        latch.countDown();
                    }
                });
                this.from("direct:two").process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        latch.countDown();
                    }
                });
            }
        });
        camelctx.start();
        try {
            ProducerTemplate producer = camelctx.createProducerTemplate();
            String result = (String)producer.requestBody("direct:start", (Object)"John,Doe", String.class);
            Assert.assertTrue((String)"Latch reached zerro", (boolean)latch.await(100L, TimeUnit.MILLISECONDS));
            Assert.assertEquals((Object)"John,Doe", (Object)result);
        }
        finally {
            camelctx.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRecipientListAnnotation() throws Exception {
        final CountDownLatch latch = new CountDownLatch(2);
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").bean(RecipientListBean.class);
                this.from("direct:one").process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        latch.countDown();
                    }
                });
                this.from("direct:two").process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        latch.countDown();
                    }
                });
            }
        });
        camelctx.start();
        try {
            ProducerTemplate producer = camelctx.createProducerTemplate();
            String result = (String)producer.requestBody("direct:start", (Object)"John,Doe", String.class);
            Assert.assertTrue((String)"Latch reached zerro", (boolean)latch.await(100L, TimeUnit.MILLISECONDS));
            Assert.assertEquals((Object)"John,Doe", (Object)result);
        }
        finally {
            camelctx.stop();
        }
    }
}

