/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.core;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.camel.test.common.types.Customer;
import org.wildfly.extension.camel.CamelAware;

@CamelAware
@RunWith(value=Arquillian.class)
public class SerializationDataFormatTest {
    @Deployment
    public static JavaArchive deployment() {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"serialization-dataformat-tests");
        archive.addClasses(new Class[]{Customer.class});
        return archive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMarshal() throws Exception {
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").marshal().serialization();
            }
        });
        Customer customer = new Customer("John", "Doe");
        camelctx.start();
        try {
            ProducerTemplate producer = camelctx.createProducerTemplate();
            byte[] result = (byte[])producer.requestBody("direct:start", (Object)customer);
            Customer obj = (Customer)new ObjectInputStream(new ByteArrayInputStream(result)).readObject();
            Assert.assertEquals((Object)"John Doe", (Object)(obj.getFirstName() + " " + obj.getLastName()));
        }
        finally {
            camelctx.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUnmarshal() throws Exception {
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").unmarshal().serialization();
            }
        });
        Customer customer = new Customer("John", "Doe");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        new ObjectOutputStream(baos).writeObject(customer);
        camelctx.start();
        try {
            ProducerTemplate producer = camelctx.createProducerTemplate();
            Customer result = (Customer)producer.requestBody("direct:start", (Object)baos.toByteArray(), Customer.class);
            Assert.assertEquals((Object)"John", (Object)result.getFirstName());
            Assert.assertEquals((Object)"Doe", (Object)result.getLastName());
        }
        finally {
            camelctx.stop();
        }
    }
}

