/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.classloading;

import org.apache.camel.impl.DefaultCamelContext;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.OperateOnDeployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.ResourceAdapterArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class CamelEnablementTest {
    private static final String DEPLOYMENT_HAWTIO_WAR = "hawtio.war";
    private static final String DEPLOYMENT_TEST_RAR = "test.rar";

    @Deployment(name="hawtio.war")
    public static WebArchive hawtioDeployment() {
        StringAsset jbossWebAsset = new StringAsset("<jboss-web><context-root>test-hawtio</context-root></jboss-web>");
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)DEPLOYMENT_HAWTIO_WAR);
        archive.addAsWebInfResource((Asset)jbossWebAsset, "jboss-web.xml");
        return archive;
    }

    @Deployment(name="test.rar")
    public static ResourceAdapterArchive rarDeployment() {
        ResourceAdapterArchive archive = (ResourceAdapterArchive)ShrinkWrap.create(ResourceAdapterArchive.class, (String)DEPLOYMENT_TEST_RAR);
        return archive;
    }

    @Test(expected=NoClassDefFoundError.class)
    @OperateOnDeployment(value="hawtio.war")
    public void testHawtioDeployment() {
        new DefaultCamelContext();
    }

    @Test(expected=NoClassDefFoundError.class)
    @OperateOnDeployment(value="test.rar")
    public void testRarDeployment() {
        new DefaultCamelContext();
    }
}

