/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.classloading;

import org.apache.camel.CamelContext;
import org.apache.camel.ServiceStatus;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.camel.test.classloading.subA.CustomFailoverException;
import org.wildfly.extension.camel.CamelContextRegistry;

@RunWith(value=Arquillian.class)
public class CustomFailoverExceptionTest {
    @ArquillianResource
    CamelContextRegistry contextRegistry;

    @Deployment
    public static JavaArchive deployment() {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"custom-failover.jar");
        archive.addAsManifestResource("classloading/custom-failover-context.xml", "jboss-camel-context.xml");
        archive.addClasses(new Class[]{CustomFailoverException.class});
        return archive;
    }

    @Test
    public void testExportedPaths() throws Exception {
        CamelContext camelctx = this.contextRegistry.getCamelContext("custom-failover-context");
        Assert.assertNotNull((String)"Context not null", (Object)camelctx);
        Assert.assertEquals((Object)ServiceStatus.Started, (Object)camelctx.getStatus());
        String name = CustomFailoverException.class.getName();
        Assert.assertNotNull((String)"Class resolved", (Object)camelctx.getClassResolver().resolveClass(name));
        Assert.assertNotNull((String)"Class loaded", camelctx.getApplicationContextClassLoader().loadClass(name));
    }
}

