/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.classloading;

import org.apache.camel.CamelContext;
import org.apache.camel.ServiceStatus;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.extension.camel.CamelContextRegistry;

@RunWith(value=Arquillian.class)
public class PropertiesFromClasspathTest {
    @ArquillianResource
    CamelContextRegistry contextRegistry;

    @Deployment
    public static JavaArchive deployment() {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"classpath-properties.jar");
        archive.addAsManifestResource("classloading/classpath-properties-context.xml", "jboss-camel-context.xml");
        archive.addAsResource("classloading/test.properties", "test.properties");
        return archive;
    }

    @Test
    public void testExportedPaths() throws Exception {
        CamelContext camelctx = this.contextRegistry.getCamelContext("classpath-properties-context");
        Assert.assertNotNull((String)"Context not null", (Object)camelctx);
        Assert.assertEquals((Object)ServiceStatus.Started, (Object)camelctx.getStatus());
        Assert.assertNotNull((String)"From not null", (Object)camelctx.getEndpoint("file:camel-test/camel-from"));
        Assert.assertNotNull((String)"To not null", (Object)camelctx.getEndpoint("file:camel-test/camel-to"));
    }
}

