/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.spring;

import java.io.InputStream;
import java.net.URL;
import org.apache.camel.CamelContext;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.ServiceStatus;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.as.arquillian.container.ManagementClient;
import org.jboss.as.controller.client.helpers.standalone.ServerDeploymentHelper;
import org.jboss.gravia.resource.ManifestBuilder;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.extension.camel.CamelAware;
import org.wildfly.extension.camel.CamelContextRegistry;

@CamelAware
@RunWith(value=Arquillian.class)
public class SpringContextDeploymentTest {
    @ArquillianResource
    CamelContextRegistry contextRegistry;
    @ArquillianResource
    ManagementClient managementClient;

    @Deployment
    public static JavaArchive createdeployment() {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"camel-deployment-tests");
        archive.addAsResource("spring/transform1-camel-context.xml", "some-other-name.xml");
        archive.setManifest(new Asset(){

            public InputStream openStream() {
                ManifestBuilder builder = new ManifestBuilder();
                builder.addManifestHeader("Dependencies", "org.jboss.as.controller-client");
                return builder.openStream();
            }
        });
        return archive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSimpleTransformFromModule() throws Exception {
        URL resourceUrl = this.getClass().getResource("/some-other-name.xml");
        ServerDeploymentHelper server = new ServerDeploymentHelper(this.managementClient.getControllerClient());
        String runtimeName = server.deploy("transform1-camel-context.xml", resourceUrl.openStream());
        try {
            CamelContext camelctx = this.contextRegistry.getCamelContext("transform1");
            Assert.assertEquals((Object)ServiceStatus.Started, (Object)camelctx.getStatus());
            ProducerTemplate producer = camelctx.createProducerTemplate();
            String result = (String)producer.requestBody("direct:start", (Object)"Kermit", String.class);
            Assert.assertEquals((Object)"Hello Kermit", (Object)result);
        }
        finally {
            server.undeploy(runtimeName);
        }
    }
}

