/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.spring;

import org.apache.camel.CamelContext;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.ServiceStatus;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.camel.test.common.types.HelloBean;
import org.wildfly.extension.camel.CamelContextRegistry;

@RunWith(value=Arquillian.class)
public class SpringBeanDeploymentTest {
    @ArquillianResource
    CamelContextRegistry contextRegistry;

    @Deployment
    public static JavaArchive createdeployment() {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"camel-deployment-tests.jar");
        archive.addClasses(new Class[]{HelloBean.class});
        archive.addAsResource("spring/bean-transformA-camel-context.xml");
        archive.addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
        return archive;
    }

    @Test
    public void testBeanTransformFromModule() throws Exception {
        CamelContext camelContext = this.contextRegistry.getCamelContext("beanA-context");
        Assert.assertEquals((Object)ServiceStatus.Started, (Object)camelContext.getStatus());
        ProducerTemplate producer = camelContext.createProducerTemplate();
        String result = (String)producer.requestBody("direct:start", (Object)"Kermit", String.class);
        Assert.assertEquals((Object)"Hello Kermit", (Object)result);
    }
}

