/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.spring;

import java.net.URL;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.ServiceStatus;
import org.apache.camel.spring.SpringCamelContext;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.extension.camel.CamelAware;
import org.wildfly.extension.camel.SpringCamelContextFactory;

@CamelAware
@RunWith(value=Arquillian.class)
public class SpringContextTest {
    @Deployment
    public static JavaArchive createdeployment() {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"camel-spring-tests");
        archive.addAsResource("spring/transform5-camel-context.xml", "some-other-name.xml");
        return archive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSpringContextFromURL() throws Exception {
        URL resourceUrl = this.getClass().getResource("/some-other-name.xml");
        SpringCamelContext camelctx = SpringCamelContextFactory.createSingleCamelContext((URL)resourceUrl, null);
        Assert.assertEquals((Object)ServiceStatus.Stopped, (Object)camelctx.getStatus());
        camelctx.start();
        try {
            ProducerTemplate producer = camelctx.createProducerTemplate();
            String result = (String)producer.requestBody("direct:start", (Object)"Kermit", String.class);
            Assert.assertEquals((Object)"Hello Kermit", (Object)result);
        }
        finally {
            camelctx.stop();
        }
    }
}

