/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.spring;

import org.apache.camel.CamelContext;
import org.apache.camel.ProducerTemplate;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.camel.test.spring.subC.PropertyValueBean;
import org.wildfly.extension.camel.CamelAware;
import org.wildfly.extension.camel.CamelContextRegistry;

@CamelAware
@RunWith(value=Arquillian.class)
public class SpringPropertyPlaceholderTest {
    @ArquillianResource
    CamelContextRegistry contextRegistry;

    @Deployment
    public static JavaArchive createDeployment() {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"camel-spring-tests");
        archive.addAsResource("spring/property-placeholder-context.xml", "spring-camel-context.xml");
        archive.addClass(PropertyValueBean.class);
        return archive;
    }

    @Test
    public void testSpringPropertyPlaceholder() throws Exception {
        CamelContext camelctx = this.contextRegistry.getCamelContext("prop-placeholder-context");
        Assert.assertNotNull((String)"Expected camel context to not be null", (Object)camelctx);
        ProducerTemplate producerTemplate = camelctx.createProducerTemplate();
        String result = (String)producerTemplate.requestBody("direct:start", null, String.class);
        Assert.assertEquals((Object)"TestValue", (Object)result);
    }
}

