/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.core;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.apache.camel.Expression;
import org.apache.camel.LoggingLevel;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.model.RouteDefinition;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.as.arquillian.api.ServerSetup;
import org.jboss.as.arquillian.api.ServerSetupTask;
import org.jboss.as.arquillian.container.ManagementClient;
import org.jboss.dmr.ModelNode;
import org.jboss.gravia.resource.ManifestBuilder;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.slf4j.LoggerFactory;
import org.wildfly.camel.test.common.utils.DMRUtils;
import org.wildfly.extension.camel.CamelAware;

@CamelAware
@RunWith(value=Arquillian.class)
@ServerSetup(value={LogSetupTask.class})
public class LogIntegrationTest {
    @Deployment
    public static JavaArchive createdeployment() {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"log-tests");
        archive.setManifest(() -> {
            ManifestBuilder builder = new ManifestBuilder();
            builder.addManifestHeader("Logging-Profile", "camel-logging-profile");
            return builder.openStream();
        });
        return archive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSimpleLog() throws Exception {
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").to("log:input")).transform((Expression)this.body().prepend((Object)"Hello "));
            }
        });
        camelctx.start();
        try {
            ProducerTemplate producer = camelctx.createProducerTemplate();
            String result = (String)producer.requestBody("direct:start", (Object)"Kermit", String.class);
            Assert.assertEquals((Object)"Hello Kermit", (Object)result);
        }
        finally {
            camelctx.stop();
        }
    }

    @Test
    public void testWildFlyLogProfile() throws Exception {
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").log(LoggingLevel.DEBUG, LoggerFactory.getLogger((String)LogIntegrationTest.class.getName()), "Hello ${body}");
            }
        });
        camelctx.start();
        try {
            ProducerTemplate producer = camelctx.createProducerTemplate();
            producer.requestBody("direct:start", (Object)"Kermit");
            this.assertLogFileContainsContent("Hello Kermit");
        }
        finally {
            camelctx.stop();
        }
    }

    @Test
    public void testWildFlyLogProfileGloabalLogConfig() throws Exception {
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.getProperties().put("CamelLogEipName", LogIntegrationTest.class.getName());
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").log("Goodbye ${body}");
            }
        });
        camelctx.start();
        try {
            ProducerTemplate producer = camelctx.createProducerTemplate();
            producer.requestBody("direct:start", (Object)"Kermit");
            this.assertLogFileContainsContent("Goodbye Kermit");
        }
        finally {
            camelctx.stop();
        }
    }

    private void assertLogFileContainsContent(String assertion) throws IOException {
        String logDir = System.getProperty("jboss.server.log.dir");
        Path logFilePath = Paths.get(logDir, "camel-log-test.log");
        List<String> logLines = Files.readAllLines(logFilePath);
        boolean match = logLines.stream().anyMatch(l -> l.matches(".*" + assertion + ".*"));
        Assert.assertTrue((String)("Log file does not contain '" + assertion + "'."), (boolean)match);
    }

    static class LogSetupTask
    implements ServerSetupTask {
        public static final String LOG_PROFILE_PREFIX = "subsystem=logging/logging-profile=camel-logging-profile";

        LogSetupTask() {
        }

        public void setup(ManagementClient managementClient, String s) throws Exception {
            ModelNode batchNode = DMRUtils.batchNode().addStep(LOG_PROFILE_PREFIX, "add").addStep("subsystem=logging/logging-profile=camel-logging-profile/file-handler=camel-log-file", "add(file={path=>camel-log-test.log,relative-to=>jboss.server.log.dir})").addStep("subsystem=logging/logging-profile=camel-logging-profile/file-handler=camel-log-file", "change-log-level(level=DEBUG))").addStep("subsystem=logging/logging-profile=camel-logging-profile/logger=" + LogIntegrationTest.class.getName(), "add(level=DEBUG,handlers=[handler=camel-log-file])").build();
            managementClient.getControllerClient().execute(batchNode);
        }

        public void tearDown(ManagementClient managementClient, String s) throws Exception {
            ModelNode batchNode = DMRUtils.batchNode().addStep(LOG_PROFILE_PREFIX, "remove").build();
            managementClient.getControllerClient().execute(batchNode);
        }
    }
}

