/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.remote;

import java.net.URI;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.component.file.GenericFileEndpoint;
import org.apache.camel.component.file.remote.FtpComponent;
import org.apache.camel.component.file.remote.FtpsConfiguration;
import org.apache.camel.component.file.remote.FtpsEndpoint;
import org.apache.camel.component.file.remote.RemoteFileConfiguration;
import org.apache.camel.util.IntrospectionSupport;
import org.apache.commons.net.ftp.FTPFile;

public class FtpsComponent
extends FtpComponent {
    public FtpsComponent() {
        this.setEndpointClass(FtpsEndpoint.class);
    }

    public FtpsComponent(CamelContext context) {
        super(context);
        this.setEndpointClass(FtpsEndpoint.class);
    }

    @Override
    protected GenericFileEndpoint<FTPFile> buildFileEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        String baseUri = this.getBaseUri(uri);
        FtpsConfiguration config = new FtpsConfiguration(new URI(baseUri));
        FtpsEndpoint endpoint = new FtpsEndpoint(uri, this, (RemoteFileConfiguration)config);
        this.extractAndSetFtpClientKeyStoreParameters(parameters, endpoint);
        this.extractAndSetFtpClientTrustStoreParameters(parameters, endpoint);
        this.extractAndSetFtpClientConfigParameters(parameters, endpoint);
        this.extractAndSetFtpClientParameters(parameters, endpoint);
        return endpoint;
    }

    protected void extractAndSetFtpClientKeyStoreParameters(Map<String, Object> parameters, FtpsEndpoint endpoint) {
        if (IntrospectionSupport.hasProperties(parameters, (String)"ftpClient.keyStore.")) {
            Map param = IntrospectionSupport.extractProperties(parameters, (String)"ftpClient.keyStore.");
            endpoint.setFtpClientKeyStoreParameters(param);
        }
    }

    protected void extractAndSetFtpClientTrustStoreParameters(Map<String, Object> parameters, FtpsEndpoint endpoint) {
        if (IntrospectionSupport.hasProperties(parameters, (String)"ftpClient.trustStore.")) {
            Map param = IntrospectionSupport.extractProperties(parameters, (String)"ftpClient.trustStore.");
            endpoint.setFtpClientTrustStoreParameters(param);
        }
    }
}

