/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.parser;

import ca.uhn.hl7v2.parser.EncodingCharacters;
import ca.uhn.hl7v2.parser.Escape;
import ca.uhn.hl7v2.parser.Escaping;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class DefaultEscaping
implements Escaping {
    private static Map<EncodingCharacters, EncLookup> variousEncChars = Collections.synchronizedMap(new LinkedHashMap<EncodingCharacters, EncLookup>(5, 0.75f, true){
        private static final long serialVersionUID = 1L;
        final int maxSize = new Integer(System.getProperty(Escape.class.getName() + ".maxSize", "1000"));

        @Override
        protected boolean removeEldestEntry(Map.Entry<EncodingCharacters, EncLookup> eldest) {
            return this.size() > this.maxSize;
        }
    });

    /*
     * Enabled aggressive block sorting
     */
    public String escape(String text, EncodingCharacters encChars) {
        EncLookup esc = DefaultEscaping.getEscapeSequences(encChars);
        int textLength = text.length();
        StringBuilder result = new StringBuilder(textLength);
        int i = 0;
        while (i < textLength) {
            boolean charReplaced = false;
            char c = text.charAt(i);
            block5: for (int j = 0; j < 6; ++j) {
                if (text.charAt(i) != esc.characters[j]) continue;
                if (j == 4 && i + 1 < textLength) {
                    char nextChar = text.charAt(i + 1);
                    switch (nextChar) {
                        case '.': 
                        case 'C': 
                        case 'M': 
                        case 'X': 
                        case 'Z': {
                            int nextEscapeIndex = text.indexOf(esc.characters[j], i + 1);
                            if (nextEscapeIndex <= 0) break;
                            result.append(text.substring(i, nextEscapeIndex + 1));
                            charReplaced = true;
                            i = nextEscapeIndex;
                            break block5;
                        }
                        case 'H': 
                        case 'N': {
                            int nextEscapeIndex;
                            if (i + 2 >= textLength || text.charAt(i + 2) != '\\' || (nextEscapeIndex = i + 2) <= 0) break;
                            result.append(text.substring(i, nextEscapeIndex + 1));
                            charReplaced = true;
                            i = nextEscapeIndex;
                            break block5;
                        }
                    }
                }
                result.append(esc.encodings[j]);
                charReplaced = true;
                break;
            }
            if (!charReplaced) {
                result.append(c);
            }
            ++i;
        }
        return result.toString();
    }

    public String unescape(String text, EncodingCharacters encChars) {
        char escapeChar = encChars.getEscapeCharacter();
        boolean foundEscapeChar = false;
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) != escapeChar) continue;
            foundEscapeChar = true;
            break;
        }
        if (!foundEscapeChar) {
            return text;
        }
        int textLength = text.length();
        StringBuilder result = new StringBuilder(textLength + 20);
        EncLookup esc = DefaultEscaping.getEscapeSequences(encChars);
        char escape = esc.characters[4];
        int encodingsCount = esc.characters.length;
        int i = 0;
        while (i < textLength) {
            char c = text.charAt(i);
            if (c != escape) {
                result.append(c);
                ++i;
                continue;
            }
            boolean foundEncoding = false;
            for (int j = 0; j < encodingsCount; ++j) {
                String encoding = esc.encodings[j];
                int encodingLength = encoding.length();
                if (i + encodingLength > textLength || !text.substring(i, i + encodingLength).equals(encoding)) continue;
                result.append(esc.characters[j]);
                i += encodingLength;
                foundEncoding = true;
                break;
            }
            if (foundEncoding) continue;
            if (i + 1 < textLength) {
                char nextChar = text.charAt(i + 1);
                switch (nextChar) {
                    case '.': 
                    case 'C': 
                    case 'M': 
                    case 'X': 
                    case 'Z': {
                        int closingEscape = text.indexOf(escape, i + 1);
                        if (closingEscape > 0) {
                            String substring = text.substring(i, closingEscape + 1);
                            result.append(substring);
                            i += substring.length();
                            break;
                        }
                        ++i;
                        break;
                    }
                    case 'H': 
                    case 'N': {
                        int closingEscape = text.indexOf(escape, i + 1);
                        if (closingEscape == i + 2) {
                            String substring = text.substring(i, closingEscape + 1);
                            result.append(substring);
                            i += substring.length();
                            break;
                        }
                        ++i;
                        break;
                    }
                    default: {
                        ++i;
                        break;
                    }
                }
                continue;
            }
            ++i;
        }
        return result.toString();
    }

    private static EncLookup getEscapeSequences(EncodingCharacters encChars) {
        EncLookup escapeSequences = variousEncChars.get(encChars);
        if (escapeSequences == null) {
            escapeSequences = new EncLookup(encChars);
            variousEncChars.put(encChars, escapeSequences);
        }
        return escapeSequences;
    }

    private static class EncLookup {
        char[] characters = new char[6];
        String[] encodings = new String[6];

        EncLookup(EncodingCharacters ec) {
            this.characters[0] = ec.getFieldSeparator();
            this.characters[1] = ec.getComponentSeparator();
            this.characters[2] = ec.getSubcomponentSeparator();
            this.characters[3] = ec.getRepetitionSeparator();
            this.characters[4] = ec.getEscapeCharacter();
            this.characters[5] = 13;
            char[] codes = new char[]{'F', 'S', 'T', 'R', 'E'};
            for (int i = 0; i < codes.length; ++i) {
                StringBuilder seq = new StringBuilder();
                seq.append(ec.getEscapeCharacter());
                seq.append(codes[i]);
                seq.append(ec.getEscapeCharacter());
                this.encodings[i] = seq.toString();
            }
            this.encodings[5] = "\\X000d\\";
        }
    }
}

