/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.validation;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.Location;
import ca.uhn.hl7v2.model.Composite;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Primitive;
import ca.uhn.hl7v2.model.Segment;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.Varies;
import ca.uhn.hl7v2.util.ReadOnlyMessageIterator;
import ca.uhn.hl7v2.util.Terser;
import ca.uhn.hl7v2.validation.EncodingRule;
import ca.uhn.hl7v2.validation.MessageRule;
import ca.uhn.hl7v2.validation.PrimitiveTypeRule;
import ca.uhn.hl7v2.validation.ValidationContext;
import ca.uhn.hl7v2.validation.ValidationException;
import ca.uhn.hl7v2.validation.ValidationExceptionHandler;
import ca.uhn.hl7v2.validation.Validator;
import java.util.ArrayList;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractValidator<R>
implements Validator<R> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractValidator.class);

    @Override
    public R validate(Message message) throws HL7Exception {
        return this.validate(message, this.initializeHandler());
    }

    @Override
    public R validate(Message message, ValidationExceptionHandler<R> handler) throws HL7Exception {
        if (message == null) {
            throw new NullPointerException("Message may not be null");
        }
        if (handler == null) {
            throw new NullPointerException("ValidationExceptionHandler may not be null");
        }
        handler.setValidationSubject(message);
        this.testMessageRules(message, handler);
        return handler.result();
    }

    private void testMessageRules(Message message, ValidationExceptionHandler<R> handler) throws HL7Exception {
        Terser t = new Terser(message);
        String messageType = t.get("MSH-9-1");
        String triggerEvent = t.get("MSH-9-2");
        ArrayList<MessageRule> rules = new ArrayList<MessageRule>();
        if (this.getValidationContext() != null) {
            rules.addAll(this.getValidationContext().getMessageRules(message.getVersion(), messageType, triggerEvent));
        }
        LOG.debug("Validating message against {} message rules", (Object)rules.size());
        for (MessageRule rule : rules) {
            ValidationException[] ex = rule.apply(message);
            if (ex == null || ex.length <= 0) continue;
            handler.onExceptions(ex);
        }
    }

    private void testPrimitiveRules(Message message, ValidationExceptionHandler<R> handler) throws HL7Exception {
        LOG.debug("Validating message against primitive type rules");
        Iterator<Structure> iter = ReadOnlyMessageIterator.createPopulatedSegmentIterator(message);
        while (iter.hasNext()) {
            Segment s = (Segment)iter.next();
            for (int field = 1; field <= s.numFields(); ++field) {
                Type[] t = s.getField(field);
                for (int rep = 0; rep < t.length; ++rep) {
                    Location location = new Location();
                    location.withSegmentName(s.getName()).withField(field).withFieldRepetition(rep);
                    this.testType(t[rep], handler, location);
                }
            }
        }
    }

    private void testType(Type type, ValidationExceptionHandler<R> handler, Location l) {
        if (type instanceof Composite) {
            Type[] components = ((Composite)type).getComponents();
            for (int comp = 0; comp < components.length; ++comp) {
                Location location = new Location(l).withComponent(comp + 1);
                this.testComponent(components[comp], handler, location);
            }
        } else if (type instanceof Varies) {
            this.testType(((Varies)type).getData(), handler, l);
        } else {
            this.testPrimitive((Primitive)type, handler, l);
        }
    }

    private void testComponent(Type type, ValidationExceptionHandler<R> handler, Location l) {
        if (type instanceof Composite) {
            Type[] component = ((Composite)type).getComponents();
            for (int sub = 0; sub < component.length; ++sub) {
                Location location = new Location(l).withSubcomponent(sub + 1);
                this.testSubComponent(component[sub], handler, location);
            }
        } else if (type instanceof Varies) {
            this.testComponent(((Varies)type).getData(), handler, l);
        } else {
            this.testPrimitive((Primitive)type, handler, l);
        }
    }

    private void testSubComponent(Type type, ValidationExceptionHandler<R> handler, Location l) {
        if (type instanceof Primitive) {
            this.testPrimitive((Primitive)type, handler, l);
        } else if (type instanceof Varies) {
            this.testSubComponent(((Varies)type).getData(), handler, l);
        }
    }

    private void testPrimitive(Primitive p, ValidationExceptionHandler<R> handler, Location l) {
        ArrayList<PrimitiveTypeRule> rules = new ArrayList<PrimitiveTypeRule>();
        Message m = p.getMessage();
        if (this.getValidationContext() != null) {
            rules.addAll(this.getValidationContext().getPrimitiveRules(m.getVersion(), p.getName(), p));
        }
        for (PrimitiveTypeRule rule : rules) {
            ValidationException[] exceptions;
            for (ValidationException ve : exceptions = rule.apply(p.getValue())) {
                ve.setLocation(l);
            }
            if (exceptions.length <= 0) continue;
            handler.onExceptions(exceptions);
        }
    }

    @Override
    public R validate(String message, boolean isXML, String version) throws HL7Exception {
        return this.validate(message, isXML, version, this.initializeHandler());
    }

    @Override
    public R validate(String message, boolean isXML, String version, ValidationExceptionHandler<R> handler) throws HL7Exception {
        if (message == null) {
            throw new NullPointerException("Message may not be null");
        }
        if (handler == null) {
            throw new NullPointerException("ValidationExceptionHandler may not be null");
        }
        handler.setValidationSubject(message);
        ArrayList<EncodingRule> rules = new ArrayList<EncodingRule>();
        if (this.getValidationContext() != null) {
            rules.addAll(this.getValidationContext().getEncodingRules(version, isXML ? "XML" : "ER7"));
        }
        LOG.debug("Validating message against {} encoding rules", (Object)rules.size());
        for (EncodingRule rule : rules) {
            ValidationException[] ex = rule.apply(message);
            if (ex == null || ex.length <= 0) continue;
            handler.onExceptions(ex);
        }
        return handler.result();
    }

    protected abstract ValidationContext getValidationContext();

    protected abstract ValidationExceptionHandler<R> initializeHandler();
}

