/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.loadbalancer;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.camel.model.LoadBalancerDefinition;
import org.apache.camel.processor.loadbalancer.CircuitBreakerLoadBalancer;
import org.apache.camel.processor.loadbalancer.LoadBalancer;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.ObjectHelper;

@XmlRootElement(name="circuitBreaker")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class CircuitBreakerLoadBalancerDefinition
extends LoadBalancerDefinition {
    @XmlElement(name="exception")
    private List<String> exceptions = new ArrayList<String>();
    @XmlAttribute
    private Long halfOpenAfter;
    @XmlAttribute
    private Integer threshold;

    @Override
    protected LoadBalancer createLoadBalancer(RouteContext routeContext) {
        CircuitBreakerLoadBalancer answer;
        if (!this.exceptions.isEmpty()) {
            ArrayList classes = new ArrayList();
            for (String name : this.exceptions) {
                Class<?> type = routeContext.getCamelContext().getClassResolver().resolveClass(name);
                if (type == null) {
                    throw new IllegalArgumentException("Cannot find class: " + name + " in the classpath");
                }
                if (!ObjectHelper.isAssignableFrom(Throwable.class, type)) {
                    throw new IllegalArgumentException("Class is not an instance of Throwable: " + type);
                }
                classes.add(type);
            }
            answer = new CircuitBreakerLoadBalancer(classes);
        } else {
            answer = new CircuitBreakerLoadBalancer();
        }
        if (this.getHalfOpenAfter() != null) {
            answer.setHalfOpenAfter(this.getHalfOpenAfter());
        }
        if (this.getThreshold() != null) {
            answer.setThreshold(this.getThreshold());
        }
        return answer;
    }

    public Long getHalfOpenAfter() {
        return this.halfOpenAfter;
    }

    public void setHalfOpenAfter(Long halfOpenAfter) {
        this.halfOpenAfter = halfOpenAfter;
    }

    public Integer getThreshold() {
        return this.threshold;
    }

    public void setThreshold(Integer threshold) {
        this.threshold = threshold;
    }

    public List<String> getExceptions() {
        return this.exceptions;
    }

    public void setExceptions(List<String> exceptions) {
        this.exceptions = exceptions;
    }

    @Override
    public String toString() {
        return "CircuitBreakerLoadBalancer";
    }
}

