/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

public final class JsonSchemaHelper {
    private JsonSchemaHelper() {
    }

    public static String getType(Class<?> type) {
        if (type.isEnum()) {
            return "enum";
        }
        if (type.isArray()) {
            return "array";
        }
        String primitive = JsonSchemaHelper.getPrimitiveType(type);
        if (primitive != null) {
            return primitive;
        }
        return "object";
    }

    public static String getPrimitiveType(Class<?> type) {
        String name = type.getCanonicalName();
        if ("java.lang.byte[]".equals(name) || "byte[]".equals(name)) {
            return "string";
        }
        if ("java.lang.Byte[]".equals(name) || "Byte[]".equals(name)) {
            return "array";
        }
        if ("java.lang.Object[]".equals(name) || "Object[]".equals(name)) {
            return "array";
        }
        if ("java.lang.String[]".equals(name) || "String[]".equals(name)) {
            return "array";
        }
        if ("java.lang.String".equals(name) || "String".equals(name)) {
            return "string";
        }
        if ("java.lang.Boolean".equals(name) || "Boolean".equals(name)) {
            return "boolean";
        }
        if ("boolean".equals(name)) {
            return "boolean";
        }
        if ("java.lang.Integer".equals(name) || "Integer".equals(name)) {
            return "integer";
        }
        if ("int".equals(name)) {
            return "integer";
        }
        if ("java.lang.Long".equals(name) || "Long".equals(name)) {
            return "integer";
        }
        if ("long".equals(name)) {
            return "integer";
        }
        if ("java.lang.Short".equals(name) || "Short".equals(name)) {
            return "integer";
        }
        if ("short".equals(name)) {
            return "integer";
        }
        if ("java.lang.Byte".equals(name) || "Byte".equals(name)) {
            return "integer";
        }
        if ("byte".equals(name)) {
            return "integer";
        }
        if ("java.lang.Float".equals(name) || "Float".equals(name)) {
            return "number";
        }
        if ("float".equals(name)) {
            return "number";
        }
        if ("java.lang.Double".equals(name) || "Double".equals(name)) {
            return "number";
        }
        if ("double".equals(name)) {
            return "number";
        }
        return null;
    }
}

