/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.kahadb.disk.util;

import org.apache.activemq.store.kahadb.disk.util.LinkedNode;

public class Sequence
extends LinkedNode<Sequence> {
    long first;
    long last;

    public Sequence(long value) {
        this.first = this.last = value;
    }

    public Sequence(long first, long last) {
        this.first = first;
        this.last = last;
    }

    public boolean isAdjacentToLast(long value) {
        return this.last + 1L == value;
    }

    public boolean isAdjacentToFirst(long value) {
        return this.first - 1L == value;
    }

    public boolean contains(long value) {
        return this.first <= value && value <= this.last;
    }

    public long range() {
        return this.first == this.last ? 1L : this.last - this.first + 1L;
    }

    public String toString() {
        return this.first == this.last ? "" + this.first : this.first + ".." + this.last;
    }

    public long getFirst() {
        return this.first;
    }

    public void setFirst(long first) {
        this.first = first;
    }

    public long getLast() {
        return this.last;
    }

    public void setLast(long last) {
        this.last = last;
    }

    public <T extends Throwable> void each(Closure<T> closure) throws T {
        for (long i = this.first; i <= this.last; ++i) {
            closure.execute(i);
        }
    }

    public static interface Closure<T extends Throwable> {
        public void execute(long var1) throws T;
    }
}

