/*
 * Decompiled with CFR 0.152.
 */
package org.dozer.loader.xml;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.dozer.MappingException;
import org.dozer.loader.xml.DozerResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public final class XMLParserFactory {
    private static final String SCHEMA_FEATURE = "http://apache.org/xml/features/validation/schema";
    private static final XMLParserFactory instance = new XMLParserFactory();

    public static XMLParserFactory getInstance() {
        return instance;
    }

    private XMLParserFactory() {
    }

    public DocumentBuilder createParser() {
        DocumentBuilderFactory factory = this.createDocumentBuilderFactory();
        try {
            return this.createDocumentBuilder(factory);
        }
        catch (ParserConfigurationException e) {
            throw new MappingException("Failed to create XML Parser !", e);
        }
    }

    private DocumentBuilderFactory createDocumentBuilderFactory() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(true);
        factory.setNamespaceAware(true);
        factory.setIgnoringElementContentWhitespace(true);
        factory.setAttribute(SCHEMA_FEATURE, true);
        return factory;
    }

    private DocumentBuilder createDocumentBuilder(DocumentBuilderFactory factory) throws ParserConfigurationException {
        DocumentBuilder docBuilder = factory.newDocumentBuilder();
        docBuilder.setErrorHandler(new DozerDefaultHandler());
        docBuilder.setEntityResolver(new DozerResolver());
        return docBuilder;
    }

    private static class DozerDefaultHandler
    extends DefaultHandler {
        private final Logger log = LoggerFactory.getLogger(DozerDefaultHandler.class);

        private DozerDefaultHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this.log.debug("tag: {}", (Object)qName);
        }

        @Override
        public void warning(SAXParseException e) throws SAXException {
            throw new SAXException(this.getMessage("Warning", e));
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            throw new SAXException(this.getMessage("Error", e));
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            throw new SAXException(this.getMessage("Fatal Error", e));
        }

        private String getMessage(String level, SAXParseException e) {
            return "Parsing " + level + "\n" + "Line:    " + e.getLineNumber() + "\n" + "URI:     " + e.getSystemId() + "\n" + "Message: " + e.getMessage();
        }
    }
}

