/*
 * Decompiled with CFR 0.152.
 */
package jnr.ffi;

import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import jnr.ffi.FFIProvider;
import jnr.ffi.LibraryOption;
import jnr.ffi.Runtime;
import jnr.ffi.provider.LoadedLibrary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Library {
    private static final Map<String, List<String>> customSearchPaths = new ConcurrentHashMap<String, List<String>>();
    private final String name;

    private Library(String libraryName) {
        this.name = libraryName;
    }

    public static final Runtime getRuntime(Object obj) {
        return ((LoadedLibrary)obj).getRuntime();
    }

    public static <T> T loadLibrary(String libraryName, Class<T> interfaceClass) {
        Map options2 = Collections.emptyMap();
        return Library.loadLibrary(libraryName, interfaceClass, options2);
    }

    public static <T> T loadLibrary(Class<T> interfaceClass, String ... libraryNames) {
        Map options2 = Collections.emptyMap();
        return Library.loadLibrary(interfaceClass, options2, libraryNames);
    }

    public static <T> T loadLibrary(String libraryName, Class<T> interfaceClass, Map<LibraryOption, ?> libraryOptions) {
        return FFIProvider.getSystemProvider().loadLibrary(libraryName, interfaceClass, libraryOptions);
    }

    public static <T> T loadLibrary(Class<T> interfaceClass, Map<LibraryOption, ?> libraryOptions, String ... libraryNames) {
        return FFIProvider.getSystemProvider().loadLibrary(interfaceClass, libraryOptions, libraryNames);
    }

    public static final synchronized void addLibraryPath(String libraryName, File path2) {
        List<String> customPaths = customSearchPaths.get(libraryName);
        if (customPaths == null) {
            customPaths = new CopyOnWriteArrayList<String>();
            customSearchPaths.put(libraryName, customPaths);
        }
        customPaths.add(path2.getAbsolutePath());
    }

    public static List<String> getLibraryPath(String libraryName) {
        List<String> customPaths = customSearchPaths.get(libraryName);
        if (customPaths != null) {
            return customPaths;
        }
        return Collections.emptyList();
    }

    public static final Library getInstance(String libraryName) {
        return new Library(libraryName);
    }

    public String getName() {
        return this.name;
    }
}

