/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class VAliasNode
extends Node {
    private String oldName;
    private String newName;

    public VAliasNode(ISourcePosition position, String newName, String oldName) {
        super(position);
        this.oldName = oldName;
        this.newName = newName;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.VALIASNODE;
    }

    @Override
    public Object accept(NodeVisitor iVisitor) {
        return iVisitor.visitVAliasNode(this);
    }

    public String getNewName() {
        return this.newName;
    }

    public String getOldName() {
        return this.oldName;
    }

    @Override
    public List<Node> childNodes() {
        return EMPTY_LIST;
    }

    @Override
    public IRubyObject interpret(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        if (this.oldName.equals("$_") || this.oldName.equals("$LAST_READ_LINE") || this.oldName.equals("$~") || this.oldName.equals("$`") || this.oldName.equals("$'") || this.oldName.equals("$+") || this.oldName.equals("$LAST_MATCH_INFO") || this.oldName.equals("$PREMATCH") || this.oldName.equals("$POSTMATCH") || this.oldName.equals("$LAST_PAREN_MATCH")) {
            runtime.getWarnings().warn(this.oldName + " is treated specially in JRuby and should not be aliased");
        }
        runtime.getGlobalVariables().alias(this.newName, this.oldName);
        return runtime.getNil();
    }
}

