/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi.jffi;

import com.kenai.jffi.CallingConvention;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.jruby.ext.ffi.CallbackInfo;
import org.jruby.ext.ffi.MappedType;
import org.jruby.ext.ffi.NativeType;
import org.jruby.ext.ffi.Type;
import org.jruby.ext.ffi.jffi.DataConverters;
import org.jruby.ext.ffi.jffi.JITHandle;
import org.jruby.ext.ffi.jffi.JITSignature;
import org.jruby.ext.ffi.jffi.NativeInvoker;
import org.jruby.ext.ffi.jffi.Signature;
import org.jruby.util.cli.Options;

class JITCompiler {
    private final Map<JITSignature, HandleRef> handles = new HashMap<JITSignature, HandleRef>();
    private final Map<Class<? extends NativeInvoker>, JITHandle> classes = new WeakHashMap<Class<? extends NativeInvoker>, JITHandle>();
    private final ReferenceQueue referenceQueue = new ReferenceQueue();
    private final JITHandle failedHandle = new JITHandle(this, new JITSignature(NativeType.VOID, new NativeType[0], false, new boolean[0], CallingConvention.DEFAULT, false), true);

    JITCompiler() {
    }

    public static JITCompiler getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private void cleanup() {
        HandleRef ref;
        while ((ref = (HandleRef)this.referenceQueue.poll()) != null) {
            this.handles.remove(ref.signature);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JITHandle getHandle(Signature signature) {
        NativeType nativeResultType;
        boolean hasResultConverter = !(signature.getResultType() instanceof Type.Builtin);
        Type resultType = signature.getResultType();
        if (resultType instanceof Type.Builtin || resultType instanceof CallbackInfo) {
            nativeResultType = resultType.getNativeType();
        } else if (resultType instanceof MappedType) {
            nativeResultType = ((MappedType)resultType).getRealType().getNativeType();
        } else {
            return this.failedHandle;
        }
        NativeType[] nativeParameterTypes = new NativeType[signature.getParameterCount()];
        boolean[] hasParameterConverter = new boolean[signature.getParameterCount()];
        for (int i2 = 0; i2 < hasParameterConverter.length; ++i2) {
            Type parameterType = signature.getParameterType(i2);
            if (parameterType instanceof Type.Builtin || parameterType instanceof CallbackInfo) {
                nativeParameterTypes[i2] = parameterType.getNativeType();
            } else if (parameterType instanceof MappedType) {
                nativeParameterTypes[i2] = ((MappedType)parameterType).getRealType().getNativeType();
            } else {
                return this.failedHandle;
            }
            hasParameterConverter[i2] = !(parameterType instanceof Type.Builtin) || DataConverters.isEnumConversionRequired(parameterType, signature.getEnums());
        }
        JITSignature jitSignature = new JITSignature(nativeResultType, nativeParameterTypes, hasResultConverter, hasParameterConverter, signature.getCallingConvention(), signature.isIgnoreError());
        JITCompiler jITCompiler = this;
        synchronized (jITCompiler) {
            JITHandle handle;
            this.cleanup();
            HandleRef ref = this.handles.get(jitSignature);
            JITHandle jITHandle = handle = ref != null ? (JITHandle)ref.get() : null;
            if (handle == null) {
                handle = new JITHandle(this, jitSignature, "OFF".equalsIgnoreCase(Options.COMPILE_MODE.load()));
                this.handles.put(jitSignature, new HandleRef(handle, jitSignature, this.referenceQueue));
            }
            return handle;
        }
    }

    void registerClass(JITHandle handle, Class<? extends NativeInvoker> klass) {
        this.classes.put(klass, handle);
    }

    private static final class HandleRef
    extends WeakReference<JITHandle> {
        JITSignature signature;

        public HandleRef(JITHandle handle, JITSignature signature, ReferenceQueue refqueue) {
            super(handle, refqueue);
            this.signature = signature;
        }
    }

    private static class SingletonHolder {
        private static final JITCompiler INSTANCE = new JITCompiler();

        private SingletonHolder() {
        }
    }
}

