/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi.jffi;

import com.kenai.jffi.Function;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.util.concurrent.atomic.AtomicInteger;
import org.jruby.RubyModule;
import org.jruby.ext.ffi.jffi.AsmClassBuilder;
import org.jruby.ext.ffi.jffi.FastIntMethodGenerator;
import org.jruby.ext.ffi.jffi.FastLongMethodGenerator;
import org.jruby.ext.ffi.jffi.FastNumericMethodGenerator;
import org.jruby.ext.ffi.jffi.JITCompiler;
import org.jruby.ext.ffi.jffi.JITMethodGenerator;
import org.jruby.ext.ffi.jffi.JITSignature;
import org.jruby.ext.ffi.jffi.NativeInvoker;
import org.jruby.ext.ffi.jffi.Signature;
import org.jruby.util.cli.Options;

final class JITHandle {
    private static final int THRESHOLD = Options.FFI_COMPILE_THRESHOLD.load();
    private final JITSignature jitSignature;
    private volatile boolean compilationFailed = false;
    private final AtomicInteger counter = new AtomicInteger(0);
    private final JITCompiler compiler;
    private Reference<Class<? extends NativeInvoker>> compiledClassRef = null;

    JITHandle(JITCompiler compiler, JITSignature signature, boolean compilationFailed) {
        this.compiler = compiler;
        this.jitSignature = signature;
        this.compilationFailed = compilationFailed;
    }

    final boolean compilationFailed() {
        return this.compilationFailed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final NativeInvoker compile(RubyModule implementationClass, Function function, Signature signature) {
        Class<? extends NativeInvoker> compiledClass;
        if (this.compilationFailed || this.counter.incrementAndGet() < THRESHOLD && !"force".equalsIgnoreCase(Options.COMPILE_MODE.load())) {
            return null;
        }
        JITHandle jITHandle = this;
        synchronized (jITHandle) {
            if (this.compiledClassRef == null || (compiledClass = this.compiledClassRef.get()) == null) {
                compiledClass = this.newInvokerClass(this.jitSignature);
                if (compiledClass == null) {
                    this.compilationFailed = true;
                    return null;
                }
                this.compiler.registerClass(this, compiledClass);
                this.compiledClassRef = new WeakReference<Class<? extends NativeInvoker>>(compiledClass);
            }
        }
        try {
            Constructor<? extends NativeInvoker> cons = compiledClass.getDeclaredConstructor(RubyModule.class, Function.class, Signature.class);
            return cons.newInstance(implementationClass, function, signature);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    Class<? extends NativeInvoker> newInvokerClass(JITSignature jitSignature) {
        JITMethodGenerator generator = null;
        JITMethodGenerator[] generators = new JITMethodGenerator[]{new FastIntMethodGenerator(), new FastLongMethodGenerator(), new FastNumericMethodGenerator()};
        for (int i2 = 0; i2 < generators.length; ++i2) {
            if (!generators[i2].isSupported(jitSignature)) continue;
            generator = generators[i2];
            break;
        }
        if (generator == null) {
            return null;
        }
        return new AsmClassBuilder(generator, jitSignature).build();
    }
}

