/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dozer;

import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.component.dozer.BaseConverter;
import org.apache.camel.spi.Language;

public class ExpressionMapper
extends BaseConverter {
    private ThreadLocal<Exchange> currentExchange = new ThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object convert(Object existingDestinationFieldValue, Object sourceFieldValue, Class<?> destinationClass, Class<?> sourceClass) {
        try {
            if (this.currentExchange.get() == null) {
                throw new IllegalStateException("Current exchange has not been set for ExpressionMapper");
            }
            Exchange exchange = this.currentExchange.get();
            Language expLang = exchange.getContext().resolveLanguage(this.getLanguagePart());
            Expression exp = expLang.createExpression(this.getExpressionPart());
            Object object = exp.evaluate(exchange, destinationClass);
            return object;
        }
        finally {
            this.done();
        }
    }

    public String getExpression() {
        return this.getParameter();
    }

    public String getExpressionPart() {
        return this.getParameter().substring(this.getParameter().indexOf(":") + 1);
    }

    public String getLanguagePart() {
        return this.getParameter().substring(0, this.getParameter().indexOf(":"));
    }

    public void setCurrentExchange(Exchange exchange) {
        this.currentExchange.set(exchange);
    }
}

