/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v24.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v24.group.RDE_O11_OBSERVATION;
import ca.uhn.hl7v2.model.v24.group.RDE_O11_ORDER_DETAIL;
import ca.uhn.hl7v2.model.v24.segment.CTI;
import ca.uhn.hl7v2.model.v24.segment.ORC;
import ca.uhn.hl7v2.model.v24.segment.RXC;
import ca.uhn.hl7v2.model.v24.segment.RXE;
import ca.uhn.hl7v2.model.v24.segment.RXR;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RDE_O11_ORDER
extends AbstractGroup {
    public RDE_O11_ORDER(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ORC.class, true, false, false);
            this.add(RDE_O11_ORDER_DETAIL.class, false, false, false);
            this.add(RXE.class, true, false, false);
            this.add(RXR.class, true, true, false);
            this.add(RXC.class, false, true, false);
            this.add(RDE_O11_OBSERVATION.class, false, true, false);
            this.add(CTI.class, false, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating RDE_O11_ORDER - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.4";
    }

    public ORC getORC() {
        ORC retVal = (ORC)this.getTyped("ORC", ORC.class);
        return retVal;
    }

    public RDE_O11_ORDER_DETAIL getORDER_DETAIL() {
        RDE_O11_ORDER_DETAIL retVal = (RDE_O11_ORDER_DETAIL)this.getTyped("ORDER_DETAIL", RDE_O11_ORDER_DETAIL.class);
        return retVal;
    }

    public RXE getRXE() {
        RXE retVal = (RXE)this.getTyped("RXE", RXE.class);
        return retVal;
    }

    public RXR getRXR() {
        RXR retVal = (RXR)this.getTyped("RXR", RXR.class);
        return retVal;
    }

    public RXR getRXR(int rep) {
        RXR retVal = (RXR)this.getTyped("RXR", rep, RXR.class);
        return retVal;
    }

    public int getRXRReps() {
        return this.getReps("RXR");
    }

    public List<RXR> getRXRAll() throws HL7Exception {
        return this.getAllAsList("RXR", RXR.class);
    }

    public void insertRXR(RXR structure, int rep) throws HL7Exception {
        super.insertRepetition("RXR", (Structure)structure, rep);
    }

    public RXR insertRXR(int rep) throws HL7Exception {
        return (RXR)super.insertRepetition("RXR", rep);
    }

    public RXR removeRXR(int rep) throws HL7Exception {
        return (RXR)super.removeRepetition("RXR", rep);
    }

    public RXC getRXC() {
        RXC retVal = (RXC)this.getTyped("RXC", RXC.class);
        return retVal;
    }

    public RXC getRXC(int rep) {
        RXC retVal = (RXC)this.getTyped("RXC", rep, RXC.class);
        return retVal;
    }

    public int getRXCReps() {
        return this.getReps("RXC");
    }

    public List<RXC> getRXCAll() throws HL7Exception {
        return this.getAllAsList("RXC", RXC.class);
    }

    public void insertRXC(RXC structure, int rep) throws HL7Exception {
        super.insertRepetition("RXC", (Structure)structure, rep);
    }

    public RXC insertRXC(int rep) throws HL7Exception {
        return (RXC)super.insertRepetition("RXC", rep);
    }

    public RXC removeRXC(int rep) throws HL7Exception {
        return (RXC)super.removeRepetition("RXC", rep);
    }

    public RDE_O11_OBSERVATION getOBSERVATION() {
        RDE_O11_OBSERVATION retVal = (RDE_O11_OBSERVATION)this.getTyped("OBSERVATION", RDE_O11_OBSERVATION.class);
        return retVal;
    }

    public RDE_O11_OBSERVATION getOBSERVATION(int rep) {
        RDE_O11_OBSERVATION retVal = (RDE_O11_OBSERVATION)this.getTyped("OBSERVATION", rep, RDE_O11_OBSERVATION.class);
        return retVal;
    }

    public int getOBSERVATIONReps() {
        return this.getReps("OBSERVATION");
    }

    public List<RDE_O11_OBSERVATION> getOBSERVATIONAll() throws HL7Exception {
        return this.getAllAsList("OBSERVATION", RDE_O11_OBSERVATION.class);
    }

    public void insertOBSERVATION(RDE_O11_OBSERVATION structure, int rep) throws HL7Exception {
        super.insertRepetition("OBSERVATION", (Structure)structure, rep);
    }

    public RDE_O11_OBSERVATION insertOBSERVATION(int rep) throws HL7Exception {
        return (RDE_O11_OBSERVATION)super.insertRepetition("OBSERVATION", rep);
    }

    public RDE_O11_OBSERVATION removeOBSERVATION(int rep) throws HL7Exception {
        return (RDE_O11_OBSERVATION)super.removeRepetition("OBSERVATION", rep);
    }

    public CTI getCTI() {
        CTI retVal = (CTI)this.getTyped("CTI", CTI.class);
        return retVal;
    }

    public CTI getCTI(int rep) {
        CTI retVal = (CTI)this.getTyped("CTI", rep, CTI.class);
        return retVal;
    }

    public int getCTIReps() {
        return this.getReps("CTI");
    }

    public List<CTI> getCTIAll() throws HL7Exception {
        return this.getAllAsList("CTI", CTI.class);
    }

    public void insertCTI(CTI structure, int rep) throws HL7Exception {
        super.insertRepetition("CTI", (Structure)structure, rep);
    }

    public CTI insertCTI(int rep) throws HL7Exception {
        return (CTI)super.insertRepetition("CTI", rep);
    }

    public CTI removeCTI(int rep) throws HL7Exception {
        return (CTI)super.removeRepetition("CTI", rep);
    }
}

