/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.amqp;

import java.io.IOException;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import javax.net.ServerSocketFactory;
import javax.net.SocketFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.BrokerServiceAware;
import org.apache.activemq.transport.MutexTransport;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.transport.amqp.AmqpNioTransport;
import org.apache.activemq.transport.amqp.AmqpTransportFilter;
import org.apache.activemq.transport.nio.NIOTransportFactory;
import org.apache.activemq.transport.tcp.TcpTransport;
import org.apache.activemq.transport.tcp.TcpTransportFactory;
import org.apache.activemq.transport.tcp.TcpTransportServer;
import org.apache.activemq.util.IntrospectionSupport;
import org.apache.activemq.wireformat.WireFormat;

public class AmqpNioTransportFactory
extends NIOTransportFactory
implements BrokerServiceAware {
    private BrokerService brokerService = null;

    protected String getDefaultWireFormatType() {
        return "amqp";
    }

    protected TcpTransportServer createTcpTransportServer(URI location, ServerSocketFactory serverSocketFactory) throws IOException, URISyntaxException {
        return new TcpTransportServer((TcpTransportFactory)this, location, serverSocketFactory){

            protected Transport createTransport(Socket socket, WireFormat format) throws IOException {
                return new AmqpNioTransport(format, socket);
            }
        };
    }

    protected TcpTransport createTcpTransport(WireFormat wf, SocketFactory socketFactory, URI location, URI localLocation) throws UnknownHostException, IOException {
        return new AmqpNioTransport(wf, socketFactory, location, localLocation);
    }

    public Transport serverConfigure(Transport transport, WireFormat format, HashMap options) throws Exception {
        if ((transport = super.serverConfigure(transport, format, options)) instanceof MutexTransport) {
            transport = ((MutexTransport)transport).getNext();
        }
        return transport;
    }

    public Transport compositeConfigure(Transport transport, WireFormat format, Map options) {
        transport = new AmqpTransportFilter((Transport)transport, format, this.brokerService);
        IntrospectionSupport.setProperties((Object)transport, (Map)options);
        return super.compositeConfigure(transport, format, options);
    }

    public void setBrokerService(BrokerService brokerService) {
        this.brokerService = brokerService;
    }

    protected boolean isUseInactivityMonitor(Transport transport) {
        return false;
    }
}

