/*
 * Decompiled with CFR 0.152.
 */
package net.sf.flatpack;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import net.sf.flatpack.Record;
import net.sf.flatpack.structure.ColumnMetaData;
import net.sf.flatpack.structure.Row;
import net.sf.flatpack.util.FPStringUtils;
import net.sf.flatpack.util.ParserUtils;
import net.sf.flatpack.xml.MetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RowRecord
implements Record {
    private Row row;
    private boolean columnCaseSensitive;
    private MetaData metaData;
    private Properties pzConvertProps = null;
    private boolean strictNumericParse;
    private boolean upperCase;
    private boolean lowerCase;
    private boolean nullEmptyString;

    public RowRecord(Row row, MetaData metaData, boolean columnCaseSensitive, Properties pzConvertProps, boolean strictNumericParse, boolean upperCase, boolean lowerCase, boolean nullEmptyString) {
        this.row = row;
        this.metaData = metaData;
        this.columnCaseSensitive = columnCaseSensitive;
        this.pzConvertProps = pzConvertProps;
        this.strictNumericParse = strictNumericParse;
        this.upperCase = upperCase;
        this.lowerCase = lowerCase;
        this.nullEmptyString = nullEmptyString;
    }

    @Override
    public boolean isRecordID(String recordID) {
        String rowID = this.row.getMdkey();
        if (rowID == null) {
            rowID = "detail";
        }
        return rowID.equals(recordID);
    }

    @Override
    public int getRowNo() {
        return this.row.getRowNumber();
    }

    @Override
    public boolean isRowEmpty() {
        return this.row.isEmpty();
    }

    @Override
    public boolean contains(String column) {
        for (ColumnMetaData cmd : ParserUtils.getColumnMetaData(this.row.getMdkey(), this.metaData)) {
            if (!cmd.getColName().equalsIgnoreCase(column)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String[] getColumns() {
        ColumnMetaData column = null;
        String[] array = null;
        if (this.metaData != null) {
            List<ColumnMetaData> cmds = this.metaData.getColumnsNames();
            array = new String[cmds.size()];
            for (int i = 0; i < cmds.size(); ++i) {
                column = cmds.get(i);
                array[i] = column.getColName();
            }
        }
        return array;
    }

    @Override
    public String[] getColumns(String recordID) {
        String[] array = null;
        if (this.metaData != null) {
            List<ColumnMetaData> cmds = ParserUtils.getColumnMetaData(recordID, this.metaData);
            array = new String[cmds.size()];
            for (int i = 0; i < cmds.size(); ++i) {
                ColumnMetaData column = cmds.get(i);
                array[i] = column.getColName();
            }
        }
        return array;
    }

    @Override
    public Date getDate(String column) throws ParseException {
        return this.getDate(column, new SimpleDateFormat("yyyyMMdd"));
    }

    @Override
    public Date getDate(String column, SimpleDateFormat sdf) throws ParseException {
        String s = this.getStringValue(column);
        if (FPStringUtils.isBlank(s)) {
            return null;
        }
        return sdf.parse(s);
    }

    @Override
    public double getDouble(String column) {
        StringBuilder newString = new StringBuilder();
        String s = this.getStringValue(column);
        if (!this.strictNumericParse) {
            newString.append(ParserUtils.stripNonDoubleChars(s));
        } else {
            newString.append(s);
        }
        return Double.parseDouble(newString.toString());
    }

    @Override
    public int getInt(String column) {
        String s = this.getStringValue(column);
        if (!this.strictNumericParse) {
            return Integer.parseInt(ParserUtils.stripNonLongChars(s));
        }
        return Integer.parseInt(s);
    }

    @Override
    public long getLong(String column) {
        String s = this.getStringValue(column);
        if (!this.strictNumericParse) {
            return Long.parseLong(ParserUtils.stripNonLongChars(s));
        }
        return Long.parseLong(s);
    }

    private String getStringValue(String column) {
        return this.row.getValue(ParserUtils.getColumnIndex(this.row.getMdkey(), this.metaData, column, this.columnCaseSensitive));
    }

    @Override
    public Object getObject(String column, Class<?> classToConvertTo) {
        String s = this.getStringValue(column);
        return ParserUtils.runPzConverter(this.pzConvertProps, s, classToConvertTo);
    }

    @Override
    public BigDecimal getBigDecimal(String column) {
        String s = this.getStringValue(column);
        if (FPStringUtils.isBlank(s)) {
            return null;
        }
        return new BigDecimal(s);
    }

    @Override
    public String getString(String column) {
        String s = this.getStringValue(column);
        if (this.nullEmptyString && FPStringUtils.isBlank(s)) {
            s = null;
        } else if (this.upperCase) {
            s = s.toUpperCase(Locale.getDefault());
        } else if (this.lowerCase) {
            s = s.toLowerCase(Locale.getDefault());
        }
        return s;
    }

    @Override
    public String getRawData() {
        return this.row.getRawData();
    }
}

