/*
 * Decompiled with CFR 0.152.
 */
package net.sf.flatpack.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.flatpack.structure.ColumnMetaData;
import net.sf.flatpack.util.ParserUtils;
import net.sf.flatpack.xml.MetaData;
import net.sf.flatpack.xml.XMLRecordElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FixedWidthParserUtils {
    private FixedWidthParserUtils() {
    }

    public static List<String> splitFixedText(List<ColumnMetaData> columnMetaData, String lineToParse, boolean preserveLeadingWhitespace, boolean preserveTrailingWhitespace) {
        ArrayList<String> splitResult = new ArrayList<String>();
        int recPosition = 1;
        for (ColumnMetaData colMetaDataObj : columnMetaData) {
            String tempValue = lineToParse.substring(recPosition - 1, recPosition + colMetaDataObj.getColLength() - 1);
            recPosition += colMetaDataObj.getColLength();
            if (!preserveLeadingWhitespace) {
                tempValue = ParserUtils.lTrim(tempValue);
            }
            if (!preserveTrailingWhitespace) {
                tempValue = ParserUtils.rTrim(tempValue);
            }
            splitResult.add(tempValue);
        }
        return splitResult;
    }

    public static String getCMDKey(MetaData columnMD, String line) {
        if (!columnMD.isAnyRecordFormatSpecified()) {
            return "detail";
        }
        Iterator<Map.Entry<String, XMLRecordElement>> mapEntries = columnMD.xmlRecordIterator();
        while (mapEntries.hasNext()) {
            int subto;
            int subfrm;
            Map.Entry<String, XMLRecordElement> entry = mapEntries.next();
            XMLRecordElement recordXMLElement = entry.getValue();
            if (recordXMLElement.getEndPositition() > line.length() || !line.substring(subfrm = recordXMLElement.getStartPosition() - 1, subto = recordXMLElement.getEndPositition()).equals(recordXMLElement.getIndicator())) continue;
            return entry.getKey();
        }
        return "detail";
    }
}

